% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bulk.R
\name{plot_set}
\alias{plot_set}
\title{Scatter plots to compare deconvoluted subclasses}
\usage{
plot_set(
  obs,
  pred,
  mfrow = NULL,
  show_zero = FALSE,
  show_identity = FALSE,
  cols = NULL,
  colour = "blue",
  title = "",
  cex.title = 1,
  ...
)
}
\arguments{
\item{obs}{Observed matrix of cell amounts with subclasses in columns and
samples in rows.}

\item{pred}{Predicted (deconvoluted) matrix of cell amounts with rows and
columns matching \code{obs}.}

\item{mfrow}{Optional vector of length 2 for organising plot layout. See
\code{par()}.}

\item{show_zero}{Logical whether to force plot to include the origin.}

\item{show_identity}{Logical whether to show the identity line.}

\item{cols}{Optional vector of column indices to plot to show either a subset
of columns or change the order in which columns are plotted. \code{NA} skips a
plot space to introduce a gap between plots.}

\item{colour}{Colour for the regression lines.}

\item{title}{Title for page of plots.}

\item{cex.title}{Font size for title.}

\item{...}{Optional arguments passed to \code{plot()}.}
}
\value{
No return value. Produces scatter plots using base graphics.
}
\description{
Produces scatter plots using base graphics to compare actual cell counts
against deconvoluted cell counts from bulk (or pseudo-bulk) RNA-Seq. Mainly
for use if ground truth is available, e.g. for simulated pseudo-bulk RNA-Seq
data.
}
