

cols <- c(
  "game_id",
  "home_team_id",
  "home_team",
  "away_team_id",
  "away_team",
  "play_id",
  "home_score",
  "away_score",
  "period",
  "clock",
  "wall_clock",
  "offense_team_id",
  "offense_team",
  "down",
  "distance",
  "yards_to_goal",
  "yards_gained",
  "play_type_id",
  "play_type",
  "ppa",
  "garbage_time",
  "success",
  "rush_pass",
  "down_type",
  "play_text",
  "drive_id",
  "drive_offense_id",
  "drive_offense_team",
  "drive_defense_id",
  "drive_defense_team",
  "drive_play_count",
  "drive_yards_gained",
  "drive_start_period",
  "drive_start_clock",
  "drive_start_yards_to_goal",
  "drive_end_period",
  "drive_end_clock",
  "drive_end_yards_to_goal",
  "drive_duration",
  "drive_scoring_opportunity",
  "drive_result",
  "drive_points_gained",
  "current_clock",
  "current_possession",
  "home_line_scores_q1",
  "home_line_scores_q2",
  "home_line_scores_q3",
  "home_line_scores_q4",
  "home_points",
  "home_drives",
  "home_scoring_opportunities",
  "home_points_per_opportunity",
  "home_average_start_yard_line",
  "home_plays",
  "home_line_yards",
  "home_line_yards_per_rush",
  "home_second_level_yards",
  "home_second_level_yards_per_rush",
  "home_open_field_yards",
  "home_open_field_yards_per_rush",
  "home_ppa_per_play",
  "home_total_ppa",
  "home_passing_ppa",
  "home_ppa_per_pass",
  "home_rushing_ppa",
  "home_ppa_per_rush",
  "home_success_rate",
  "home_standard_down_success_rate",
  "home_passing_down_success_rate",
  "home_explosiveness",
  "home_deserve_to_win",
  "away_line_scores_q1",
  "away_line_scores_q2",
  "away_line_scores_q3",
  "away_line_scores_q4",
  "away_points",
  "away_drives",
  "away_scoring_opportunities",
  "away_points_per_opportunity",
  "away_average_start_yard_line",
  "away_plays",
  "away_line_yards",
  "away_line_yards_per_rush",
  "away_second_level_yards",
  "away_second_level_yards_per_rush",
  "away_open_field_yards",
  "away_open_field_yards_per_rush",
  "away_ppa_per_play",
  "away_total_ppa",
  "away_passing_ppa",
  "away_ppa_per_pass",
  "away_rushing_ppa",
  "away_ppa_per_rush",
  "away_success_rate",
  "away_standard_down_success_rate",
  "away_passing_down_success_rate",
  "away_explosiveness",
  "away_deserve_to_win"
)

test_that("CFB Live Plays", {
  skip_on_cran()
  x <- cfbd_live_plays(game_id = 401520182)

  y <- cfbd_live_plays(game_id = 401110720)

  expect_in(colnames(x), cols)
  expect_in(colnames(y), cols)
  expect_s3_class(x, "data.frame")
  expect_s3_class(y, "data.frame")
})
