\name{duke_endocarditis_criteria}
\alias{duke_endocarditis_criteria}
\title{
Modified Duke Criteria for Infective Endocarditis
}
\description{
Calculates the classification (Definite, Possible, or Rejected) for Infective Endocarditis based on the Modified Duke Criteria. This set of diagnostic criteria integrates pathologic, clinical, laboratory, and echocardiographic findings.
}
\usage{
duke_endocarditis_criteria(pathologic_lesions, major_blood_cultures,
                           major_echo, predisposition_heart_condition,
                           fever_gt_38, vascular_phenomena,
                           immunologic_phenomena, minor_blood_culture_findings)
}
\arguments{
  \item{pathologic_lesions}{
Numeric (0 or 1). Pathologic lesions (vegetation or intracardiac abscess) demonstrating active endocarditis on histology OR microorganisms demonstrated by culture/histology of vegetation/emboli. (1 = Yes).
}
  \item{major_blood_cultures}{
Numeric (0 or 1). Positive blood cultures meeting specific criteria (typical microorganisms consistent with IE from 2 separate cultures, persistent positive cultures, or single positive for Coxiella burnetii). (1 = Yes).
}
  \item{major_echo}{
Numeric (0 or 1). Evidence of endocardial involvement (vegetation, abscess, new partial dehiscence of prosthetic valve, or new valvular regurgitation). (1 = Yes).
}
  \item{predisposition_heart_condition}{
Numeric (0 or 1). Predisposing heart condition or intravenous drug use. (1 = Yes).
}
  \item{fever_gt_38}{
Numeric (0 or 1). Fever >= 38.0 C (100.4 F). (1 = Yes).
}
  \item{vascular_phenomena}{
Numeric (0 or 1). Major arterial emboli, septic pulmonary infarcts, mycotic aneurysm, intracranial hemorrhage, conjunctival hemorrhages, or Janeway lesions. (1 = Yes).
}
  \item{immunologic_phenomena}{
Numeric (0 or 1). Glomerulonephritis, Osler's nodes, Roth spots, or Rheumatoid factor. (1 = Yes).
}
  \item{minor_blood_culture_findings}{
Numeric (0 or 1). Microbiologic evidence (positive blood culture but does not meet major criteria, or serologic evidence of active infection with organism consistent with IE). (1 = Yes).
}
}
\value{
A list containing:
\item{Classification}{"Definite Infective Endocarditis", "Possible Infective Endocarditis", or "Rejected".}
\item{Criteria_Met}{Summary of the counts of Major and Minor criteria identified.}
}
\references{
Li JS, Sexton DJ, Mick N, et al. Proposed modifications to the Duke criteria for the diagnosis of infective endocarditis. Clin Infect Dis. 2000;30(4):633-638. doi:10.1086/313753
}
\examples{

# Example 1: Definite IE (1 Major + 3 Minor)
# Major Echo, Fever, Vascular, Immunologic
duke_endocarditis_criteria(0, 0, 1, 0, 1, 1, 1, 0)

# Example 2: Possible IE (3 Minor)
# Fever, Predisposition, Minor Culture
duke_endocarditis_criteria(0, 0, 0, 1, 1, 0, 0, 1)
}
