\name{slicc_sle_criteria}
\alias{slicc_sle_criteria}
\title{
SLICC Criteria for Systemic Lupus Erythematosus (SLE)
}
\description{
Evaluates the 2012 SLICC (Systemic Lupus International Collaborating Clinics) criteria for the diagnosis of Systemic Lupus Erythematosus. Diagnosis requires either: 1) Biopsy-proven lupus nephritis with positive ANA or Anti-dsDNA, OR 2) At least 4 criteria met, including at least one clinical criterion and one immunologic criterion.
}
\usage{
slicc_sle_criteria(acute_cutaneous_lupus, chronic_cutaneous_lupus, oral_ulcers,
                   alopecia, synovitis, serositis, renal_clinical, neurologic,
                   hemolytic_anemia, leukopenia_lymphopenia, thrombocytopenia,
                   ana, anti_dsdna, anti_sm, antiphospholipid_antibody,
                   low_complement, direct_coombs, biopsy_proven_nephritis)
}
\arguments{
  \item{acute_cutaneous_lupus}{Numeric (0/1). Presence of acute cutaneous lupus (e.g., malar rash).}
  \item{chronic_cutaneous_lupus}{Numeric (0/1). Presence of chronic cutaneous lupus (e.g., discoid rash).}
  \item{oral_ulcers}{Numeric (0/1). Oral or nasal ulcers.}
  \item{alopecia}{Numeric (0/1). Non-scarring alopecia.}
  \item{synovitis}{Numeric (0/1). Synovitis involving 2 or more joints.}
  \item{serositis}{Numeric (0/1). Serositis (pleuritis or pericarditis).}
  \item{renal_clinical}{Numeric (0/1). Renal criteria (urine protein/creatinine ratio or red blood cell casts).}
  \item{neurologic}{Numeric (0/1). Neurologic criteria (seizures, psychosis, etc.).}
  \item{hemolytic_anemia}{Numeric (0/1). Hemolytic anemia.}
  \item{leukopenia_lymphopenia}{Numeric (0/1). Leukopenia (<4000/mm3) or Lymphopenia (<1000/mm3).}
  \item{thrombocytopenia}{Numeric (0/1). Thrombocytopenia (<100,000/mm3).}
  \item{ana}{Numeric (0/1). Positive ANA (Antinuclear Antibody).}
  \item{anti_dsdna}{Numeric (0/1). Positive Anti-dsDNA.}
  \item{anti_sm}{Numeric (0/1). Positive Anti-Sm.}
  \item{antiphospholipid_antibody}{Numeric (0/1). Positive Antiphospholipid antibody.}
  \item{low_complement}{Numeric (0/1). Low complement (C3, C4, or CH50).}
  \item{direct_coombs}{Numeric (0/1). Positive Direct Coombs test. (Note: Counts as immunologic criterion only in the absence of hemolytic anemia).}
  \item{biopsy_proven_nephritis}{Numeric (0/1). Biopsy-proven lupus nephritis.}
}
\value{
A list containing:
\item{Diagnosis}{"Systemic Lupus Erythematosus (SLE)" or "Criteria Not Met".}
\item{Total_Criteria_Met}{Count of total criteria met (adjusted for Coombs rule).}
\item{Breakdown}{Breakdown of Clinical and Immunologic counts.}
}
\references{
Petri M, Orbai AM, Alarcón GS, et al. Derivation and validation of the Systemic Lupus International Collaborating Clinics classification criteria for systemic lupus erythematosus. Arthritis Rheum. 2012;64(8):2677-2686. doi:10.1002/art.34473
}
\examples{
# Example 1: Diagnosis via Criteria Count
# Malar rash (1), Arthritis (1), Renal (1), ANA (1) -> 3 Clinical, 1 Immuno, Total 4
slicc_sle_criteria(1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0)

# Example 2: Diagnosis via Biopsy
# No clinical symptoms, but Biopsy Nephritis (1) and ANA (1)
slicc_sle_criteria(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1)
}
