\name{ukeld_score}
\alias{ukeld_score}
\title{
United Kingdom Model for End-Stage Liver Disease (UKELD)
}
\description{
Calculates the UKELD score, used in the United Kingdom to assess the severity of chronic liver disease and determine eligibility for liver transplantation listing. A UKELD score of 49 or greater typically indicates a 1-year mortality risk of approximately 9\%, which is considered the minimum threshold for listing.
}
\usage{
ukeld_score(bilirubin_umol_l, inr, creatinine_umol_l, sodium_mmol_l)
}
\arguments{
  \item{bilirubin_umol_l}{
Numeric. Serum Bilirubin level in micromol/L. (Note: UKELD uses micromol/L, unlike MELD which often uses mg/dL).
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{creatinine_umol_l}{
Numeric. Serum Creatinine level in micromol/L.
}
  \item{sodium_mmol_l}{
Numeric. Serum Sodium level in mmol/L.
}
}
\details{
The formula is:
\deqn{UKELD = (5.395 \times \ln(INR)) + (1.266 \times \ln(Bilirubin)) + (1.541 \times \ln(Creatinine)) + (1.567 \times \ln(Sodium))}
Values for Bilirubin, INR, and Creatinine are capped at a minimum of 1.0 to avoid negative logarithms.
}
\value{
A list containing:
\item{UKELD_Score}{The calculated score (rounded to the nearest integer).}
\item{Listing_Criteria}{Indication of whether the score meets the minimum threshold for transplant listing.}
\item{Est_1_Year_Mortality_Without_Transplant}{Estimated 1-year mortality percentage.}
}
\references{
Barber K, et al. The UKELD score: validation of a new scoring system for liver transplantation in the UK.
Neuberger J, Gimson A, Davies M, et al. Selection of patients for liver transplantation and allocation of donated livers in the UK. Gut. 2008;57(2):252-257. doi:10.1136/gut.2007.131730
}
\examples{

# Example 1: Meets Listing Criteria
# Bili 50, INR 1.5, Cr 100, Na 135
ukeld_score(50, 1.5, 100, 135)

# Example 2: Below Listing Criteria
# Bili 15, INR 1.1, Cr 70, Na 140
ukeld_score(15, 1.1, 70, 140)
}
