% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crypto_list.R
\name{exchange_list}
\alias{exchange_list}
\title{Retrieves name, CMC id, symbol, slug, rank, an activity flag as well as activity dates on CMC for all coins}
\usage{
exchange_list(only_active = TRUE, add_untracked = FALSE)
}
\arguments{
\item{only_active}{Shall the code only retrieve active exchanges (TRUE=default) or include inactive coins (FALSE)}

\item{add_untracked}{Shall the code additionally retrieve untracked exchanges (FALSE=default)}
}
\value{
List of (active and historically existing) exchanges in a tibble:
\item{id}{CMC exchange id (unique identifier)}
\item{name}{Exchange name}
\item{slug}{Exchange URL slug (unique)}
\item{is_active}{Flag showing whether exchange is active (1), inactive(0) or untracked (-1)}
\item{first_historical_data}{First time listed on CMC}
\item{last_historical_data}{Last time listed on CMC, \emph{today's date} if still listed}
}
\description{
This code uses the web api. It retrieves data for all historic and all active exchanges and does not require an 'API' key.
}
\examples{
\dontrun{
# return all exchanges
ex_active_list <- exchange_list(only_active=TRUE)
ex_all_but_untracked_list <- exchange_list(only_active=FALSE)
ex_full_list <- exchange_list(only_active=FALSE,add_untracked=TRUE)
}

}
