% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_stackedbar}
\alias{plot_stackedbar}
\title{Plot stacked bar}
\usage{
plot_stackedbar(data, label_x = "", label_y = "", colors = NULL, alpha = 1)
}
\arguments{
\item{data}{data.frame with category in first column and series in remaining columns}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional vector of fill colors, one per series}

\item{alpha}{bar transparency (0–1)}
}
\value{
returns a ggplot2::ggplot graphic
}
\description{
Stacked bar chart for multiple series per category.
}
\details{
Expects a data.frame with category in the first column and series in remaining columns.
Bars are stacked within each category. Provide \code{colors} (one per series) to control fills.
}
\examples{
#summarizing iris dataset
data <- iris |> dplyr::group_by(Species) |>
dplyr::summarize(Sepal.Length=mean(Sepal.Length), Sepal.Width=mean(Sepal.Width))

#plotting data
grf <- plot_stackedbar(data, colors=c("blue", "red"))
plot(grf)
}
