% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_lasso.R
\name{fs_lasso}
\alias{fs_lasso}
\title{LASSO Feature Selection}
\usage{
fs_lasso(attribute)
}
\arguments{
\item{attribute}{Character. Name of the target variable.}
}
\value{
A \code{fs_lasso} object.
}
\description{
Performs feature selection using L1-regularized regression (LASSO),
implemented with \code{glmnet}.
}
\examples{
\dontrun{
data(iris)

# 1) LASSO requires a numeric response
fs <- daltoolbox::fit(fs_lasso("Sepal.Length"), iris)
fs$features                 # selected predictors with non-zero coefficients

# 2) Subset data to selected features + target
data_lasso <- daltoolbox::transform(fs, iris)
head(data_lasso)
}
}
\references{
Tibshirani, R. (1996). Regression Shrinkage and Selection via the Lasso.
}
