agg.wtd.quantile <- function(x, by, weights = NULL, prob = 0.5, na.rm = FALSE) {
  if(is.null(weights)) weights <- rep(1, nrow(data.frame(x)))
  res <- split(data.frame(weights,x), by)
  if(ncol(res[[1]])==2) {
    res <- data.frame(mean = sapply(res, function(z) weighted.quantile(z[,2], z[,1], probs = prob, na.rm = na.rm)))
  } else {
    res <- do.call("rbind.data.frame", args = lapply(res, function(z) sapply(z[,-1], weighted.quantile, weights = z[,1], probs = prob, na.rm = na.rm)))
    colnames(res) <- colnames(x)
    rownames(res) <- levels(by)
  }
  return(res)
}