\name{agg.wtd.var}
\alias{agg.wtd.var}

\title{
Aggregated Weighted Variance
}

\description{
Splits the data into subsets (according to the levels of a factor) and computes the weighted variance for each
}

\usage{
agg.wtd.var(x, by, weights = NULL, na.rm = FALSE)
}

\arguments{
  \item{x}{numeric vector or data frame of numeric vectors}
  \item{by}{factor used to split the data}  
  \item{weights}{numeric vector of weights. If NULL (default), uniform weights (i.e. all equal to 1) are used.}
  \item{na.rm}{logical, indicating whether NA values should be silently removed before the computation proceeds. Default is FALSE.}
}

\value{
a data frame
}

\author{
Nicolas Robette
}

\seealso{
\code{\link{agg.wtd.mean}}
}

\examples{
data(Movies)
agg.wtd.var(Movies[,c("Critics", "BoxOffice")], by = Movies$Country)
}

\keyword{ multivariate }
\keyword{ misc }
