% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_study.R
\name{event_study}
\alias{event_study}
\alias{plot_event_study}
\title{Estimate event-study coefficients using TWFE and 5 proposed improvements.}
\usage{
event_study(
  data,
  yname,
  idname,
  gname,
  tname,
  xformla = NULL,
  weights = NULL,
  estimator = c("all", "TWFE", "did2s", "did", "impute", "sunab", "staggered"),
  verbose = TRUE
)

plot_event_study(out, separate = TRUE, horizon = NULL)
}
\arguments{
\item{data}{The dataframe containing all the variables}

\item{yname}{Variable name for outcome variable}

\item{idname}{Variable name for unique unit id}

\item{gname}{Variable name for unit-specific date of initial treatment
(never-treated should be zero or NA)}

\item{tname}{Variable name for calendar period}

\item{xformla}{A formula for the covariates to include in the model.
It should be of the form \code{~ X1 + X2}. Default is NULL.}

\item{weights}{Variable name for estimation weights. This is used in
estimating Y(0) and also augments treatment effect weights.
Implementation of Roth and Sant'Anna (2021) currently does not allow for weights.}

\item{estimator}{Estimator you would like to use. Use "all" to estimate all.
Otherwise see table to know advantages and requirements for each of these.}

\item{verbose}{Optional. Logical. Should information about the two-stage
procedure be printed back to the user?
Default is \code{TRUE}.}

\item{out}{Output from \code{\link[=event_study]{event_study()}}}

\item{separate}{Logical. Should the estimators be on separate plots? Default is TRUE.}

\item{horizon}{Numeric. Vector of length 2. First element is min and
second element is max of event_time to plot}
}
\value{
\code{event_study} returns a data.frame of point estimates for each estimator

\code{plot_event_study} returns a ggplot object that can be fully customized
}
\description{
Uses the estimation procedures recommended from Borusyak, Jaravel, Spiess (2021); Callaway and Sant'Anna (2020); Gardner (2021); Roth and Sant'Anna (2021); Sun and Abraham (2020)
}
\examples{
\donttest{
out = event_study(
  data = did2s::df_het, yname = "dep_var", idname = "unit",
  tname = "year", gname = "g", estimator = "all"
)
plot_event_study(out)
}
}
