% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cauchy.R
\name{Cauchy}
\alias{Cauchy}
\title{Create a Cauchy distribution}
\usage{
Cauchy(location = 0, scale = 1)
}
\arguments{
\item{location}{The location parameter. Can be any real number. Defaults
to \code{0}.}

\item{scale}{The scale parameter. Must be greater than zero (?). Defaults
to \code{1}.}
}
\value{
A \code{Cauchy} object.
}
\description{
Note that the Cauchy distribution is the student's t distribution
with one degree of freedom. The Cauchy distribution does not have
a well defined mean or variance. Cauchy distributions often appear
as priors in Bayesian contexts due to their heavy tails.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a Cauchy variable with mean
\verb{location =} \eqn{x_0} and \code{scale} = \eqn{\gamma}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: Undefined.

\strong{Variance}: Undefined.

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{1}{\pi \gamma \left[1 + \left(\frac{x - x_0}{\gamma} \right)^2 \right]}
  }{
    f(x) = 1 / (\pi \gamma (1 + ((x - x_0) / \gamma)^2)
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(t) = \frac{1}{\pi} \arctan \left( \frac{t - x_0}{\gamma} \right) +
      \frac{1}{2}
  }{
    F(t) = arctan((t - x_0) / \gamma) / \pi + 1/2
  }

\strong{Moment generating function (m.g.f)}:

Does not exist.
}
\examples{

set.seed(27)

X <- Cauchy(10, 0.2)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
\seealso{
Other continuous distributions: 
\code{\link{Beta}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GEV}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
