% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonBinomial.R
\name{PoissonBinomial}
\alias{PoissonBinomial}
\title{Create a Poisson binomial distribution}
\usage{
PoissonBinomial(...)
}
\arguments{
\item{...}{An arbitrary number of numeric vectors or matrices
of success probabilities in \verb{[0, 1]} (with matching number of rows).}
}
\value{
A \code{PoissonBinomial} object.
}
\description{
The Poisson binomial distribution is a generalization of the
\code{\link[distributions3]{Binomial}} distribution. It is also a sum
of \eqn{n} independent Bernoulli experiments. However, the success
probabilities can vary between the experiments so that they are
not identically distributed.
}
\details{
The Poisson binomial distribution comes up when you consider the number
of successes in independent binomial experiments (coin flips) with
potentially varying success probabilities.

The \code{PoissonBinomial} distribution class in \pkg{distributions3}
is mostly based on the \pkg{PoissonBinomial} package, providing fast
\pkg{Rcpp} implementations of efficient algorithms. Hence, it is
recommended to install the \pkg{PoissonBinomial} package when working
with this distribution. However, as a fallback for when the \pkg{PoissonBinomial}
package is not installed the methods for the \code{PoissonBinomial}
distribution employ a normal approximation.

We recommend reading the following documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail.

In the following, let \eqn{X} be a Poisson binomial random variable with
success probabilities \eqn{p_1} to \eqn{p_n}.

\strong{Support}: \eqn{\{0, 1, 2, ..., n\}}{{0, 1, 2, ..., n}}

\strong{Mean}: \eqn{p_1 + \dots + p_n}{p_1 + ... + p_n}

\strong{Variance}: \eqn{p_1 \cdot (1 - p_1) + \dots + p_1 \cdot (1 - p_1)}{p_1 (1 - p_1) + ... + p_n (1 - p_n)}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = k) = \sum_A \prod_{i \in A} p_i \prod_{j \in A^C} (1 - p_j)
  }{
    P(X = k) = sum_A prod_{i in A} p_i prod_{j in A^C} (1 - p_j)
  }

where the sum is taken over all sets \eqn{A} with \eqn{k} elements from
\eqn{\{0, 1, 2, ..., n\}}{{0, 1, 2, ..., n}}. \eqn{A^C} is the complement
of \eqn{A}.

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le k) = \sum_{i=0}^{\lfloor k \rfloor} P(X = i)
  }{
    P(X \le k) = \sum_{i=0}^k P(X = i)
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \prod_{i = 1}^n (1 - p_i + p_i e^t)
  }{
    E(e^(tX)) = prod_{i = 1}^n (1 - p_i + p_i e^t)
  }
}
\examples{

set.seed(27)

X <- PoissonBinomial(0.5, 0.3, 0.8)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.8)

cdf(X, quantile(X, 0.8))
quantile(X, cdf(X, 2))

## equivalent definitions of four Poisson binomial distributions
## each summing up three Bernoulli probabilities
p <- cbind(
  p1 = c(0.1, 0.2, 0.1, 0.2),
  p2 = c(0.5, 0.5, 0.5, 0.5),
  p3 = c(0.8, 0.7, 0.9, 0.8))
PoissonBinomial(p)
PoissonBinomial(p[, 1], p[, 2], p[, 3])
PoissonBinomial(p[, 1:2], p[, 3])
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{Geometric}()},
\code{\link{HurdleNegativeBinomial}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{ZINegativeBinomial}()},
\code{\link{ZIPoisson}()},
\code{\link{ZTNegativeBinomial}()},
\code{\link{ZTPoisson}()}
}
\concept{discrete distributions}
