% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_parquet_duckdb.R
\name{read_parquet_duckdb}
\alias{read_parquet_duckdb}
\title{Read Parquet files using DuckDB}
\usage{
read_parquet_duckdb(
  path,
  ...,
  prudence = c("thrifty", "lavish", "stingy"),
  options = list()
)
}
\arguments{
\item{path}{Path to files, glob patterns \code{*} and \verb{?} are supported.}

\item{...}{These dots are for future extensions and must be empty.}

\item{prudence}{Memory protection, controls if DuckDB may convert
intermediate results in DuckDB-managed memory to data frames in R memory.
\itemize{
\item \code{"thrifty"}: up to a maximum size of 1 million cells,
\item \code{"lavish"}: regardless of size,
\item \code{"stingy"}: never.
}

The default is \code{"thrifty"} for the ingestion functions,
and may be different for other functions.
See \code{vignette("prudence")} for more information.}

\item{options}{Arguments to the DuckDB \code{read_parquet} table function.}
}
\description{
\code{read_parquet_duckdb()} reads a Parquet file using DuckDB's \code{read_parquet()} table function.
}
\seealso{
\code{\link[=read_csv_duckdb]{read_csv_duckdb()}}, \code{\link[=read_json_duckdb]{read_json_duckdb()}}
}
