% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmfcm.R
\name{rmfcm}
\alias{rmfcm}
\title{Random generation from the exponential Factor Copula Model (eFCM)}
\usage{
rmfcm(
  lambda,
  delta,
  dist = NULL,
  coord = NULL,
  nu = 0.5,
  n = 5e+05,
  miles = FALSE,
  seed = NULL
)
}
\arguments{
\item{lambda, delta}{Positive scalars: rate \eqn{\lambda} and range \eqn{\delta}.}

\item{dist}{Optional \eqn{d\times d} distance matrix. If \code{NULL}, provide \code{coord}.}

\item{coord}{Optional two-column matrix/data.frame of station coordinates (lon, lat).
Used to build \code{dist} via \code{fields::rdist.earth()}.}

\item{nu}{Matérn smoothness parameter (default \code{0.5}).}

\item{n}{Number of simulated rows (default \code{5e5}).}

\item{miles}{Logical passed to \code{fields::rdist.earth} (default \code{FALSE}).}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
A numeric matrix of size \code{n x d} (rows = samples, cols = stations).
}
\description{
Draws \eqn{n} samples from the eFCM.
}
\examples{
\donttest{
data(LonLat)
sim <- rmfcm(lambda = 2, delta = 100, coord = LonLat[1:2, ], n = 10000)
dim(sim)  # 10000 x 2
}
}
