% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_to_xl.R
\name{write_to_xl}
\alias{write_to_xl}
\title{Export easysurv output to Excel via \code{openxlsx}}
\usage{
write_to_xl(wb, object)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet}

\item{object}{The output of an easysurv command}
}
\value{
An Excel workbook with the easysurv output.
}
\description{
Export easysurv output to Excel via \code{openxlsx}
}
\examples{
km_results <- get_km(
  data = easysurv::easy_bc,
  time = "recyrs",
  event = "censrec",
  group = "group",
  risktable_symbols = FALSE
)

wb <- openxlsx::createWorkbook()

\dontrun{
write_to_xl(wb, km_results)
openxlsx::saveWorkbook(wb, "km_results.xlsx", overwrite = TRUE)
openxlsx::openXL("km_results.xlsx")
}
}
