% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_set_config_from_file}
\alias{epitrax_set_config_from_file}
\title{Set report configuration of EpiTrax object from config file}
\usage{
epitrax_set_config_from_file(epitrax, filepath)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{filepath}{Path to the report configuration file.}
}
\value{
Updated EpiTrax object with \code{config} field set.
}
\description{
\code{epitrax_set_config_from_file} reads a report configuration file and adds it to the
EpiTrax object.
}
\examples{
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
epitrax <- structure(
  list(data = c(1,2,3)),
  class = "epitrax"
)
epitrax <- epitrax_set_config_from_file(epitrax, config_file)
}
\seealso{
\code{\link[=epitrax_set_config_from_list]{epitrax_set_config_from_list()}} and the convenience function
\code{\link[=setup_epitrax]{setup_epitrax()}} which wraps this function
}
