% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_gene_ref.R
\name{download_gene_ref}
\alias{download_gene_ref}
\title{Download gene annotation reference table from Ensembl}
\usage{
download_gene_ref(
  species = c("human", "mouse"),
  remove_empty_symbol = FALSE,
  remove_na_entrez = FALSE,
  save = FALSE,
  save_path = NULL
)
}
\arguments{
\item{species}{Organism, either \code{"human"} or \code{"mouse"}. Default is \code{"human"}.}

\item{remove_empty_symbol}{Logical. Remove entries with missing gene symbol. Default: \code{FALSE}.}

\item{remove_na_entrez}{Logical. Remove entries with missing Entrez ID. Default: \code{FALSE}.}

\item{save}{Logical. Whether to save the result as \code{.rds}. Default: \code{FALSE}.}

\item{save_path}{File path to save (optional). If \code{NULL}, will use default \verb{gene_ref_<species>_<date>.rds}.}
}
\value{
A \code{data.frame} containing gene annotation.
}
\description{
Downloads a standardized gene annotation table for human or mouse using \code{biomaRt}.
Includes Ensembl ID, gene symbol, Entrez ID, gene type, chromosome location, and other metadata.
}
