% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec_ops.R
\name{vectors}
\alias{vectors}
\alias{\%a\%}
\alias{v_union}
\alias{\%u\%}
\alias{v_diff}
\alias{\%d\%}
\alias{v_intersect}
\alias{\%i\%}
\alias{v_xor}
\alias{\%e\%}
\alias{\%r\%}
\alias{n_intersect}
\alias{\%n_i\%}
\alias{n_diff}
\alias{\%n_d\%}
\title{Infix operations on vectors - append, diff, intersection, union, replication}
\usage{
e1 \%a\% e2

v_union(e1, e2)

e1 \%u\% e2

v_diff(e1, e2)

e1 \%d\% e2

v_intersect(e1, e2)

e1 \%i\% e2

v_xor(e1, e2)

e1 \%e\% e2

e1 \%r\% e2

n_intersect(e1, e2)

e1 \%n_i\% e2

n_diff(e1, e2)

e1 \%n_d\% e2
}
\arguments{
\item{e1}{vector or data.frame, matrix, list for \code{\%n_d\%}, \code{\%n_i\%})}

\item{e2}{vector or function for \code{\%d\%}, \code{\%i\%}}
}
\value{
vector or data.frame, matrix, list for \code{\%n_d\%}, \code{\%n_i\%})
}
\description{
All these functions except \code{\%n_d\%}, \code{\%n_i\%} preserve names of
vectors and don't remove duplicates.
\itemize{
\item \code{\%a\%} a(ppends) second argument to the first argument. See also
\link[base]{append}.
\item \code{\%u\%} and \code{v_union} u(nite) first and second arguments.
Remove elements from the second argument which exist in the first argument.
\item \code{\%d\%} and \code{v_diff} d(iff) second argument from the first
argument. Second argument could be a function which returns logical value. In
this case elements of the first argument which give TRUE will be removed.
\item \code{\%i\%} and \code{v_intersect} i(ntersect) first argument and
second argument. Second argument could be a function which returns logical
value. In this case elements of the first argument which give FALSE will be
removed.
\item \code{\%e\%} and \code{v_xor} e(xclusive OR). Returns elements that
contained only in one of arguments.
\item \code{\%r\%}  r(epeats) first argument second argument times. See
also \link[base]{rep}.
\item \code{\%n_d\%} and \code{n_diff} n(ames) d(iff) - diff second argument
from names of first argument. Second argument could be a function which
returns logical value. In this case elements of the first argument which names
give TRUE will be removed.
\item \code{\%n_i\%} and \code{n_intersect} n(ames) i(ntersect) - intersect
names of the first argument with the second argument. Second argument could be a
function which returns logical value. In this case elements of the first argument
which names give FALSE will be removed.
} 
For \code{\%d\%}, \code{\%i\%}, \code{\%n_d\%}, \code{\%n_i\%} one can use
criteria functions. See \link{criteria} for details.
}
\examples{

1:4 \%a\% 5:6   # 1:6

1:4 \%a\% 4:5   # 1,2,3,4,4,5

1:4 \%u\% 4:5   # 1,2,3,4,5

1:6 \%d\% 5:6   # 1:4

# function as criterion
1:6 \%d\% greater(4) # 1:4

1:4 \%i\% 4:5   # 4

# with criteria functions 
letters \%i\% (contains("a") | contains("z")) # a, z

letters \%i\% perl("[a-d]") # a,b,c,d

1:4 \%e\% 4:5   # 1, 2, 3, 5

1:2 \%r\% 2     # 1, 2, 1, 2

# \%n_i\%, \%n_d\%

# remove column Species
iris \%n_d\% "Species" 

# leave only columns which names start with "Sepal"
iris \%n_i\% like("Sepal*") 

# leave column "Species" and columns which names start with "Sepal" 
iris \%n_i\% ("Species" | like("Sepal*")) 
iris \%n_i\% or("Species", like("Sepal*")) # same result

}
