% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_display.R
\name{repr_mode}
\alias{repr_mode}
\title{Display Modes for Extinction Probabilities}
\usage{
repr_mode(g)
}
\arguments{
\item{g}{Numeric scalar, a probability in the unit interval. May be
non-finite.}
}
\value{
\code{repr_mode()} returns a character scalar, one of:
\itemize{
\item \code{"linear_G"} – display \eqn{G} on the linear scale;
\item \code{"log_G"} – display \eqn{G} on log10 scale for tiny
probabilities;
\item \code{"log_Q"} – display \eqn{Q=1-G} on log10 scale when
\eqn{G \approx 1};
\item \code{"undefined"} – input was not finite.
}

\code{format_by_mode()} returns a character scalar formatted according to
the selected mode and the kind of value (point estimate, lower, or upper
CI bound).
}
\description{
A pair of internal functions for formatting extinction probabilities:
\code{repr_mode()} decides how to represent a probability \eqn{G} based on
its magnitude, and \code{format_by_mode()} formats numbers accordingly for
presentation. These functions affect display only and do not alter
underlying calculations.
}
\details{
Probabilities very close to 0 or 1 are displayed on a log scale to improve
readability. The thresholds are fixed at \code{1e-300} ("near zero") and
\code{1 - 1e-15} ("near one"). Non-finite inputs are reported as
\code{"undefined"}.
}
\author{
Hiroshi Hakoyama, \email{hiroshi.hakoyama@gmail.com}
}
\keyword{internal}
