% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{define_translate}
\alias{define_translate}
\title{Create an Inverse Cell ID Translation Function}
\usage{
define_translate(ncol_src, ncol_tgt, row_offset, col_offset)
}
\arguments{
\item{ncol_src}{Integer. Number of columns in the source raster.}

\item{ncol_tgt}{Integer. Number of columns in the target raster.}

\item{row_offset}{Integer. Row offset of the target grid's top-left corner
relative to the source grid's top-left corner (0-based).}

\item{col_offset}{Integer. Column offset of the target grid's top-left corner
relative to the source grid's top-left corner (0-based).}
}
\value{
A function that takes a vector of source cell IDs (`cell_src`) and
  returns a vector of corresponding target cell IDs. Cells falling outside
  the target grid bounds will have `NA_integer_` as their target ID.
}
\description{
Generates a function to translate cell IDs from a source raster grid
to a target raster grid, considering potential offsets and different dimensions.
Handles cases where the target grid is a subset (e.g., cropped/masked)
of the source grid.
}
\keyword{internal}
