% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrf.R
\name{evaluate.HRF}
\alias{evaluate.HRF}
\title{Evaluate an HRF Object}
\usage{
\method{evaluate}{HRF}(
  x,
  grid,
  amplitude = 1,
  duration = 0,
  precision = 0.2,
  summate = TRUE,
  normalize = FALSE,
  ...
)
}
\arguments{
\item{x}{The HRF object (inherits from `HRF` and `function`).}

\item{grid}{A numeric vector of time points at which to evaluate the HRF.}

\item{amplitude}{The scaling value for the event (default: 1).}

\item{duration}{The duration of the event (seconds). If > 0, the HRF is evaluated over this duration (default: 0).}

\item{precision}{The temporal resolution for evaluating responses when duration > 0 (default: 0.2).}

\item{summate}{Logical; whether the HRF response should accumulate over the duration (default: TRUE). If FALSE, the maximum response within the duration window is taken (currently only supported for single-basis HRFs).}

\item{normalize}{Logical; scale output so that the peak absolute value is 1 (default: FALSE). Applied *after* amplitude scaling and duration processing.}

\item{...}{Additional arguments (unused).}
}
\value{
A numeric vector or matrix of HRF values at the specified time points.
}
\description{
This function evaluates a hemodynamic response function (HRF) object for a given set of time points (grid) and other parameters.
It handles both point evaluation (duration=0) and block evaluation (duration > 0).
}
\examples{
# Evaluate canonical HRF at specific times
times <- seq(0, 20, by = 0.5)
response <- evaluate(HRF_SPMG1, times)

# Evaluate with amplitude scaling
response_scaled <- evaluate(HRF_SPMG1, times, amplitude = 2)

# Evaluate with duration (block design)
response_block <- evaluate(HRF_SPMG1, times, duration = 5, summate = TRUE)

# Multi-basis HRF evaluation
response_multi <- evaluate(HRF_SPMG3, times)  # Returns 3-column matrix
}
