% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressor-set.R
\name{regressor_set}
\alias{regressor_set}
\alias{evaluate.RegSet}
\title{Construct a Regressor Set}
\usage{
regressor_set(
  onsets,
  fac,
  hrf = HRF_SPMG1,
  duration = 0,
  amplitude = 1,
  span = 40,
  summate = TRUE
)

\method{evaluate}{RegSet}(
  x,
  grid,
  precision = 0.33,
  method = c("conv", "fft", "Rconv", "loop"),
  sparse = FALSE,
  ...
)
}
\arguments{
\item{onsets}{Numeric vector of event onset times.}

\item{fac}{A factor (or object coercible to a factor) indicating the
condition for each onset.}

\item{hrf}{Hemodynamic response function used for all conditions.}

\item{duration}{Numeric scalar or vector of event durations.}

\item{amplitude}{Numeric scalar or vector of event amplitudes.}

\item{span}{Numeric scalar giving the HRF span in seconds.}

\item{summate}{Logical; passed to [regressor()].}

\item{x}{A RegSet object}

\item{grid}{Numeric vector of time points at which to evaluate}

\item{precision}{Numeric precision for evaluation}

\item{method}{Evaluation method}

\item{sparse}{Logical whether to return sparse matrix}

\item{...}{Additional arguments passed to evaluate}
}
\value{
An object of class `RegSet` containing one `Reg` per factor level.
}
\description{
Creates a set of regressors, one for each level of a factor. Each
condition shares the same HRF and other parameters but has distinct
onsets, durations and amplitudes.
}
\examples{
# Create events for 3 conditions
onsets <- c(10, 20, 30, 40, 50, 60)
conditions <- factor(c("A", "B", "C", "A", "B", "C"))

# Create regressor set
rset <- regressor_set(onsets, conditions, hrf = HRF_SPMG1)

# With durations and amplitudes
rset2 <- regressor_set(
  onsets = onsets,
  fac = conditions,
  duration = 2,
  amplitude = c(1, 1.5, 0.8, 1, 1.5, 0.8),
  hrf = HRF_SPMG1
)

# Evaluate the regressor set
times <- seq(0, 80, by = 0.1)
design_matrix <- evaluate(rset, times)
}
