% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHelp.R
\docType{data}
\name{readmission2}
\alias{readmission2}
\title{Transformed Readmission Data for Illness-Death Modeling}
\format{
A data frame with one row per subject, containing columns suitable
  for use with the \code{IllnessDeath} function:
  \describe{
    \item{id}{Unique subject identification number.}
    \item{observed_disease_time}{Time (in years since surgery) to either the first rehospitalization (illness), death, or administrative censoring, whichever occurred first.}
    \item{observed_death_time}{Time (in years since surgery) to either death or administrative censoring.}
    \item{disease_status}{Indicator for the non-terminal event (first rehospitalization). 1 if the subject experienced a first rehospitalization before death/censoring, 0 otherwise.}
    \item{death_status}{Indicator for the terminal event (death). 1 if the subject died, 0 if censored.}
    \item{dukes}{Dukes' tumoral stage at baseline (Factor or numeric: 1:A-B; 2:C; 3:D).}
    \item{sex}{Gender (Factor or numeric: 1:Male; 2:Female).}
    \item{charlson}{Comorbidity Charlson's index at baseline (Factor or numeric: 0: Index 0; 1: Index 1-2; 3: Index >=3). Note: Original data had this as time-dependent, this version likely uses the baseline value.}
    \item{chemo}{Indicator whether patient received chemotherapy (Factor or numeric: 1:No; 2:Yes).}
    \item{group}{An example grouping variable (numeric, derived from id mod 10 + 1), useful for fitting grouped frailty models.}
}
}
\source{
Derived from the \code{readmission} dataset, originally described in:
Gonzalez, JR., Fernandez, E., Moreno, V., Ribes, J., Peris, M., Navarro, M.,
Cambray, M. and Borras, JM (2005). Sex differences in hospital readmission
among colorectal cancer patients. \emph{Journal of Epidemiology and
Community Health}, \bold{59}, 6, 506-511.
}
\usage{
data(readmission2)
}
\description{
A dataset derived from the \code{readmission} data (originally from the
\code{frailtypack} package, related to rehospitalization times after surgery
in colorectal cancer patients). This transformed version reshapes the data
to fit a standard illness-death model framework, focusing on the first
event (rehospitalization) and the terminal event (death). Recurrent
rehospitalization events beyond the first one are excluded. Time is scaled to years.
}
\details{
The transformation process involved:
\enumerate{
  \item Starting with the original \code{readmission} data.
  \item Excluding recurrent rehospitalization events, keeping only the interval from surgery (t.start=0) to the first event (event=1) or censoring (event=0).
  \item Reshaping the data so each row represents one subject.
  \item Defining \code{observed_disease_time} and \code{disease_status} based on the first event interval (t.stop when t.start=0).
  \item Defining \code{observed_death_time} and \code{death_status} based on the overall follow-up time and final death status for the subject. If a subject had a first event and then further follow-up, the death time comes from the second interval if available.
  \item Scaling time variables (\code{t.stop}) from days (assumed) to years by dividing by 365.
  \item Copying baseline covariates (dukes, sex, charlson, chemo) from the subject's first record.
}
This dataset is intended primarily for demonstrating the \code{IllnessDeath} function.
}
\keyword{datasets}
