% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mghheader.R
\name{mghheader.vox2ras}
\alias{mghheader.vox2ras}
\title{Compute vox2ras matrix from basic MGH header fields.}
\usage{
mghheader.vox2ras(header)
}
\arguments{
\item{header}{the MGH header}
}
\value{
4x4 numerical matrix, the transformation matrix
}
\description{
This is also known as the 'scanner' or 'native' vox2ras.  It is the inverse of the respective ras2vox, see \code{\link[freesurferformats]{mghheader.ras2vox}}.
}
\examples{
    brain_image = system.file("extdata", "brain.mgz",
                               package = "freesurferformats",
                               mustWork = TRUE);
    vdh = read.fs.mgh(brain_image, with_header = TRUE);
    mghheader.vox2ras(vdh$header);

}
\seealso{
\code{\link{sm0to1}}

Other header coordinate space: 
\code{\link{mghheader.is.ras.valid}()},
\code{\link{mghheader.ras2vox}()},
\code{\link{mghheader.ras2vox.tkreg}()},
\code{\link{mghheader.scanner2tkreg}()},
\code{\link{mghheader.tkreg2scanner}()},
\code{\link{mghheader.vox2ras.tkreg}()},
\code{\link{read.fs.transform}()},
\code{\link{read.fs.transform.dat}()},
\code{\link{read.fs.transform.lta}()},
\code{\link{read.fs.transform.xfm}()},
\code{\link{sm0to1}()},
\code{\link{sm1to0}()}
}
\concept{header coordinate space}
