% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jurdou_bib.R
\name{jurdou_bib}
\alias{jurdou_bib}
\title{Function to prepare metadata for the main laws containing the DOU for automatic insertion into scientific articles}
\usage{
jurdou_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of laws containing DOU}

\item{input_tam}{is the length of the dataframe with the laws containing DOU, obtained using package bibliorefer.}
}
\value{
The output of the jurdou_bib function is the file with the .bib extension, of the laws containing DOU in BibTex format, prepared to be automatically included in the scientific reference list.
}
\description{
The jurdou_bib function prepares the metadata of laws containing DOU to be automatically included in a scientific article. The jurdou_bib function internally calls two support functions. The output of the jurdou_bib function is the file with the .bib extension, of the laws containing DOU in BibTex format, prepared to be automatically included in the scientific reference list.
}
\examples{

# Example

# File of database
file_db <- system.file("extdata","leicomdou.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 2

#Calls the function jurdou_bib
jurdou_bibtex <- jurdou_bib(input_date, input_tam)
jurdou_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
