% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-.R
\docType{data}
\name{patch}
\alias{patch}
\alias{Patch}
\title{Get Patch representation}
\usage{
patch(x)
}
\arguments{
\item{x}{Any objects has a Patch representation}
}
\value{
A \code{ggalign::Patch}
object.
}
\description{
\code{ggalign::Patch} represents the
layout manager for a single subplot within a composite plot. The \code{Patch}
object provides the interface for aligning the subplot, managing panel sizes,
and handling guide legends.
}
\details{
In \code{alignpatches()}, each subplot is regarded as a \code{patch}, and \strong{a
corresponding \code{Patch} object is required} for proper alignment and layout
operations. \code{Patch} is a \code{\link[ggplot2:ggproto]{ggproto()}} object that provides
the core methods for arranging and aligning subplots.
}
\section{Fields}{

\describe{
\item{\code{guides}}{\strong{Description}

(Optional method) Determines which sides of the guide legends should be
collected by the parent \code{\link[=alignpatches]{alignpatches()}} object.

This per-plot method allows each subplot to modify the \code{guides} passed to
the \code{self$decompose_guides()} method, ensuring that plots along the
border collect their guide legends correctly. Such fine-grained control
cannot be achieved when relying on only a single
\code{self$decompose_guides()} method.

\strong{Arguments}
\itemize{
\item \code{guides}: The \code{guides} argument passed from the parent
\code{\link[=alignpatches]{alignpatches()}} object, specifying how legends should be combined or
positioned. Possible values include \code{"top"}, \code{"left"}, \code{"bottom"}, and \code{"right"}.
}

\strong{Value}
A modified \code{guides} object indicating which sides of the guide legends
should be collected by the parent \code{\link[=alignpatches]{alignpatches()}} object.}

\item{\code{gtable}}{\strong{Description}

(Required method) Constructs a
\code{\link[=standardized_gtable]{standardized gtable}} object.

\strong{Arguments}
\itemize{
\item \code{theme}: The global \code{\link[ggplot2:theme]{theme}} of the parent
\code{\link[=alignpatches]{alignpatches()}} object.
\item \code{guides}: Specifies which sides of guide legends should be collected by
the parent \code{\link[=alignpatches]{alignpatches()}} object. In most cases, this is the value
returned by the subplot's \code{self$guides()} method. For plots along the
border, any guide legends on that side will always be collected if any
legends on that side of any subplot are being collected.
\item \code{tagger}: Either \code{NULL} (no tagging) or a \code{LayoutTagger} object that
provides a \verb{$tag_table} method (accepting the \code{gtable} and \code{theme})
used to add tag.
}

\strong{Value}
A standardized \code{\link[gtable:gtable]{gtable}} object representing the plot
layout.}

\item{\code{decompose_guides}}{\strong{Description}

(Optional method) Collects guide legends and optionally removes the space
they occupy.

This method extracts guide legends based on the sides specified in the
\code{guides} argument. After collecting the guides, the corresponding space
in the the \code{gt} is removed to free up space, except for guides
placed \code{inside} the panel.

\strong{Arguments}
\itemize{
\item \code{gt}: A \code{\link[gtable:gtable]{gtable}} object, usually returned by
\code{self$gtable()}.
\item \code{guides}: Specifies which sides of guide legends should be collected by
the parent \code{\link[=alignpatches]{alignpatches()}} object. In most cases, this is the value
returned by the subplot's \code{self$guides()} method. For plots along the
border, any guide legends on that side will always be collected if any
legends on that side of any subplot are being collected.
}

\strong{Value}
A list with:
\itemize{
\item \code{gt}: The updated gtable with guide legends removed (if applicable).
\item \code{guides}: A named list of collected guide grobs corresponding to the
sides specified in \code{guides} (or \code{NULL} if absent).
}}

\item{\code{align_panel}}{\strong{Description}

(Optional method) In most cases, panel sizes do not need to be manually
adjusted when aligning panels, as long as their border sizes are
consistent. However, for gtables with a fixed aspect ratio, this method
adjusts the panel width and height based on user input and the dimensions
of the underlying gtable (\code{gt}) to ensure proper alignment.

When the internal \emph{numeric value} of either \code{panel_width} or
\code{panel_height} is \code{NA} (i.e., \code{is.na(as.numeric(...))}), that dimension
is inferred from the gtable while maintaining the aspect ratio for
single-panel layouts when \code{respect = TRUE}.

\strong{Arguments}
\itemize{
\item \code{gt}: A \code{\link[gtable:gtable]{gtable}} object, usually returned by
\code{self$decompose_guides()}.
\item \code{panel_width}/\code{panel_height}: Unit objects specifying the desired panel
size. If the internal numeric value of either is \code{NA}, the size is
computed from the gtable (\code{gt}).
}

\strong{Value}
A list with components:
\itemize{
\item \code{width}: Final panel width as a unit object
\item \code{height}: Final panel height as a unit object
\item \code{respect}: If \code{TRUE}, the aspect ratio was enforced
}}

\item{\code{border_sizes}}{\strong{Description}

(Optional method) retrieve the border sizes of a gtable.

\strong{Arguments}
\itemize{
\item \code{gt}: A \code{\link[gtable:gtable]{gtable}} object, usually returned by
\code{self$decompose_guides()}.
\item \code{free}: Optional. Borders to exclude when calculating sizes. Possible
values include \code{"top"}, \code{"left"}, \code{"bottom"}, and \code{"right"}.
}

\strong{Value}
A list with components:
\itemize{
\item \code{top}: \code{unit} values for the top borders.
\item \code{left}: \code{unit} values for the left borders.
\item \code{bottom}: \code{unit} values for the bottom borders.
\item \code{right}: \code{unit} values for the right borders.
}}

\item{\code{align_border}}{\strong{Description}

(Optional method) This method modifies the top, left, bottom, and right
border sizes of the underlying gtable (\code{gt}) by replacing corresponding
entries in its \code{heights} and \code{widths} vectors..

\strong{Arguments}
\itemize{
\item \code{gt}: A \code{\link[gtable:gtable]{gtable}} object, usually returned by
\code{self$decompose_guides()}.
\item \code{t}, \code{l}, \code{b}, \code{r}: Optional numeric vectors specifying new sizes for
the top, left, bottom, and right borders, respectively. Each vector
replaces the corresponding entries in \code{gt$heights} or \code{gt$widths}.
}

\strong{Value}
A modified \code{\link[gtable:gtable]{gtable}} object.}

\item{\code{place}}{\strong{Description}
(Optional method) Inserts the patch's gtable (including optional
background) into the target canvas gtable.

This method places the patch's gtable into a specified location of
another gtable, preserving the background and plot layers separately if a
background exists. The \code{t}, \code{l}, \code{b}, \code{r} arguments specify the position
in the target gtable, and \code{bg_z} / \code{plot_z} define the stacking order
(z-order) for background and plot.

\strong{Arguments}
\itemize{
\item \code{gtable}: the target canvas gtable into which the patch will be
inserted.
\item \code{gt}: A \code{\link[gtable:gtable]{gtable}} object, usually returned by
\code{self$align_border()}.
\item \code{t}, \code{l}, \code{b}, \code{r}: Integer positions (top, left, bottom, right)
specifying where to insert the patch in the target gtable.
\item \code{i}: Index of the current patch, used to generate unique grob names.
\item \code{bg_z}: Z-order for the background grob (default \code{1L}).
\item \code{plot_z}: Z-order for the plot grob (default \code{2L}).
}

\strong{Details}
\itemize{
\item If the patch includes a grob named \code{"background"}, it is separated from
the main plot and inserted independently from the plot grob.
\item If no background is present, the entire gtable is inserted as the plot
grob.
}

\strong{Value}
The modified target canvas gtable with the patch's gtable added.}

\item{\code{decompose_bg}}{\strong{Description}
Separates the background grob (if present) from the main gtable.

\strong{Value}
A list with:
\itemize{
\item \code{bg}: The background grob (or \code{NULL} if absent)
\item \code{gt}: The gtable with background removed
}}

\item{\code{place_bg}}{\strong{Description}
Adds the background grob into the target gtable.}

\item{\code{place_gt}}{\strong{Description}
Adds the main plot gtable into the target gtable.}

\item{\code{is_alignpatches}}{\strong{Description}

Checks whether the object inherits from the \code{\link[=alignpatches]{alignpatches()}} \code{Patch}
representation.

If \code{TRUE}, the fields \code{self$patches}, \code{self$gt_list}, and
\code{self$borders_list} are expected to exist in the \verb{$align_border()} and
\verb{$place()} methods. See the \code{patch.ggalign_free_lab} function in the
\code{alignpatch-free-lab.R} script for an example of usage.

\strong{Value}
Logical value (\code{TRUE} or \code{FALSE}) indicating whether \code{self} is a
\code{PatchAlignpatches} object.}
}}

\examples{
patch(ggplot())
}
\seealso{
\code{\link[=alignpatches]{alignpatches()}}/\code{\link[=align_plots]{align_plots()}}
}
\keyword{datasets}
\keyword{internal}
