% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoscatter.R
\docType{data}
\name{geom_geoscatter}
\alias{geom_geoscatter}
\alias{stat_geoscatter}
\alias{StatGeoscatter}
\title{Place points randomly or in a grid within locations}
\usage{
geom_geoscatter(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "geoscatter",
  position = "identity",
  ...,
  feature_type = NA,
  sample_type = "random",
  inset = NA,
  map_base = "clip",
  map_inset = "auto",
  na.rm = TRUE,
  show.legend = "point",
  inherit.aes = TRUE
)

stat_geoscatter(
  mapping = NULL,
  data = NULL,
  geom = "sf_inset",
  position = "identity",
  ...,
  feature_type = NA,
  sample_type = "random",
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, stat, geom, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.}

\item{feature_type}{Type of map feature. See \code{\link[cartographer:feature_types]{feature_types()}} for a list of
registered types. If \code{NA}, the type is guessed based on the values in
\code{feature_names}.}

\item{sample_type}{sampling type (see the \code{type} argument of \code{\link[sf:st_sample]{sf::st_sample()}}).
\code{"random"} will place points randomly inside the boundaries, whereas
\code{"regular"} and \code{"hexagonal"} will evenly space points, leaving
a small margin close to the boundaries.}

\item{inset}{Inset configuration; see \code{\link[ggmapinset:configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[ggmapinset:coord_sf_inset]{coord_sf_inset()}}).}

\item{map_base}{Controls the layer with the base map. Possible values are
\code{"normal"} to create a layer as though the inset were not specified,
\code{"clip"} to create a layer with the inset viewport cut out, and
\code{"none"} to prevent the insertion of a layer for the base map.}

\item{map_inset}{Controls the layer with the inset map. Possible values are
\code{"auto"} to choose the behaviour based on whether \code{inset} is specified,
\code{"normal"} to create a layer with the viewport cut out and transformed, and
\code{"none"} to prevent the insertion of a layer for the viewport map.}
}
\value{
A ggplot layer.
}
\description{
Each row of data is drawn as a single point inside the geographic area. This
has similar strengths to a standard scatter plot, but has the potential to
be misleading by implying that there is significance to the exact placement
of the points.
}
\section{Aesthetics}{

The \code{location} aesthetic is required.
\code{geom_geoscatter()} understands the same aesthetics as \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.
}

\section{Computed variables}{

\describe{
\item{x}{longitude}
\item{y}{latitude}
}
}

\examples{
library(ggplot2)

cartographer::nc_type_example_2 |>
  ggplot(aes(location = county)) +
  geom_boundaries(feature_type = "sf.nc") +
  geom_geoscatter(aes(colour = type), size = 0.5) +
  coord_automap(feature_type = "sf.nc")
}
\keyword{datasets}
