% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-cartesian-.R
\name{coord_cartesian}
\alias{coord_cartesian}
\title{Cartesian coordinates}
\usage{
coord_cartesian(
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  default = FALSE,
  clip = "on",
  reverse = "none",
  ratio = NULL
)
}
\arguments{
\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.
Giving a logical vector will separately control the expansion for the four
directions (top, left, bottom and right). The \code{expand} argument will be
recycled to length 4 if necessary. Alternatively, can be a named logical
vector to control a single direction, e.g. \code{expand = c(bottom = FALSE)}.}

\item{default}{Is this the default coordinate system? If \code{FALSE} (the default),
then replacing this coordinate system with another one creates a message alerting
the user that the coordinate system is being replaced. If \code{TRUE}, that warning
is suppressed.}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. In most cases, the default of \code{"on"} should not be changed,
as setting \code{clip = "off"} can cause unexpected results. It allows
drawing of data points anywhere on the plot, including in the plot margins. If
limits are set via \code{xlim} and \code{ylim} and some data points fall outside those
limits, then those data points may show up in places such as the axes, the
legend, the plot title, or the plot margins.}

\item{reverse}{A string giving which directions to reverse. \code{"none"}
(default) keeps directions as is. \code{"x"} and \code{"y"} can be used to reverse
their respective directions. \code{"xy"} can be used to reverse both
directions.}

\item{ratio}{aspect ratio, expressed as \code{y / x}. Can be \code{NULL} (default) to
not use an aspect ratio. Using \code{1} ensures that one unit on the x-axis
is the same length as one unit on the y-axis. Ratios higher than one make
units on the y-axis longer than units on the x-axis, and vice versa.}
}
\description{
The Cartesian coordinate system is the most familiar, and common, type of
coordinate system. Setting limits on the coordinate system will zoom the
plot (like you're looking at it with a magnifying glass), and will not
change the underlying data like setting limits on a scale will.
}
\examples{
# There are two ways of zooming the plot display: with scales or
# with coordinate systems.  They work in two rather different ways.

p <- ggplot(mtcars, aes(disp, wt)) +
  geom_point() +
  geom_smooth()
p

# Setting the limits on a scale converts all values outside the range to NA.
p + scale_x_continuous(limits = c(325, 500))

# Setting the limits on the coordinate system performs a visual zoom.
# The data is unchanged, and we just view a small portion of the original
# plot. Note how smooth continues past the points visible on this plot.
p + coord_cartesian(xlim = c(325, 500))

# By default, the same expansion factor is applied as when setting scale
# limits. You can set the limits precisely by setting expand = FALSE
p + coord_cartesian(xlim = c(325, 500), expand = FALSE)

# Similarly, we can use expand = FALSE to turn off expansion with the
# default limits
p + coord_cartesian(expand = FALSE)

# Using a fixed ratio: 1 y-axis unit is 100 x-axis units
# Plot window can be resized and aspect ratio will be maintained
p + coord_cartesian(ratio = 100)

# You can see the same thing with this 2d histogram
d <- ggplot(diamonds, aes(carat, price)) +
  stat_bin_2d(bins = 25, colour = "white")
d

# When zooming the scale, the we get 25 new bins that are the same
# size on the plot, but represent smaller regions of the data space
d + scale_x_continuous(limits = c(0, 1))

# When zooming the coordinate system, we see a subset of original 50 bins,
# displayed bigger
d + coord_cartesian(xlim = c(0, 1))
}
