% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/party.R
\name{scale_party}
\alias{scale_party}
\alias{scale_fill_party_c}
\alias{scale_color_party_c}
\alias{scale_fill_party_d}
\alias{scale_color_party_d}
\alias{scale_fill_party_b}
\alias{scale_color_party_b}
\alias{scale_colour_party_d}
\alias{scale_colour_party_c}
\alias{scale_colour_party_b}
\title{Partisan scales for \code{ggplot2}}
\usage{
scale_fill_party_c(
  name = "Vote share",
  midpoint = 0.5,
  limits = 0:1,
  labels = label_party_pct(),
  oob = scales::squish,
  reverse = FALSE,
  ...
)

scale_color_party_c(
  name = "Vote share",
  midpoint = 0.5,
  limits = 0:1,
  labels = label_party_pct(),
  oob = scales::squish,
  reverse = FALSE,
  ...
)

scale_fill_party_d(labels = c("Rep.", "Dem."), reverse = FALSE, ...)

scale_color_party_d(labels = c("Rep.", "Dem."), reverse = FALSE, ...)

scale_fill_party_b(
  name = "Vote share",
  midpoint = 0.5,
  limits = 0:1,
  labels = label_party_pct(),
  oob = scales::squish,
  reverse = FALSE,
  nice.breaks = FALSE,
  ...
)

scale_color_party_b(
  name = "Vote share",
  midpoint = 0.5,
  limits = 0:1,
  labels = label_party_pct(),
  oob = scales::squish,
  reverse = FALSE,
  nice.breaks = FALSE,
  ...
)

scale_colour_party_d(labels = c("Rep.", "Dem."), reverse = FALSE, ...)

scale_colour_party_c(
  name = "Vote share",
  midpoint = 0.5,
  limits = 0:1,
  labels = label_party_pct(),
  oob = scales::squish,
  reverse = FALSE,
  ...
)

scale_colour_party_b(
  name = "Vote share",
  midpoint = 0.5,
  limits = 0:1,
  labels = label_party_pct(),
  oob = scales::squish,
  reverse = FALSE,
  nice.breaks = FALSE,
  ...
)
}
\arguments{
\item{name}{Name for scale. Default is \code{"Vote share"}.}

\item{midpoint}{Scale midpoint value. Default is \code{0.5}.}

\item{limits}{Lower and upper limits for scale. Default is \code{0:1}.}

\item{labels}{Function to adjust scale labels. Default is \code{scales::percent}.}

\item{oob}{Function to deal with out of bounds. Default is \code{scales::squish()}.}

\item{reverse}{Whether to reverse red and blue.}

\item{...}{Additional arguments to \verb{ggplot::scale_*} functions}

\item{nice.breaks}{If \code{TRUE}, attempt to place breaks at nice values instead
of exactly evenly spaced between the limits.}
}
\value{
ggplot scale function
}
\description{
Partisan scales for \code{ggplot2}
}
\examples{
library(ggplot2)
data(oregon)

ggplot(oregon, aes(fill = ndv / (ndv + nrv))) +
    geom_sf(size = 0) +
    scale_fill_party_c(limits=c(0.3, 0.7)) +
    theme_map()

ggplot(oregon, aes(fill = ndv / (ndv + nrv))) +
    geom_sf(size = 0) +
    scale_fill_party_b() +
    theme_map()

}
\concept{colors}
