% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggside-themes.R, R/zzz.R
\name{theme_ggside_grey}
\alias{theme_ggside_grey}
\alias{theme_ggside_gray}
\alias{theme_ggside_bw}
\alias{theme_ggside_linedraw}
\alias{theme_ggside_light}
\alias{theme_ggside_dark}
\alias{theme_ggside_minimal}
\alias{theme_ggside_classic}
\alias{theme_ggside_void}
\alias{ggside-theme}
\title{ggside custom themes}
\usage{
theme_ggside_grey(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_gray(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_bw(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_linedraw(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_light(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_dark(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_minimal(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_classic(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)

theme_ggside_void(
  base_size = 11,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22
)
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{base_line_size}{base size for line elements}

\item{base_rect_size}{base size for rect elements}
}
\description{
Theme elements to help customize the look and feel of
\link{ggside}'s side panels.
}
\details{
Incomplete themes:

Unlike the complete themes like \link[ggplot2]{theme_grey}, \code{ggside}'s variants are not
considered "complete". This is because the user may want to specify the side panels
separately from the theme of the main panel. This means that \verb{theme_ggside_*()} functions
should be called after any of \code{ggplot2}'s complete themes.
}
\section{ggside theme elements}{


\tabular{ll}{
\code{ggside.panel.scale, ggside.panel.scale.x, ggside.panel.scale.y} \tab expects a scalar numeric
that sets the scaling of side panels relative to the plotting width/height of the main panels.
Default is set to 0.1. i.e. 0.1 indicates side panels are 1/10th the size of the main panel whereas 1
indicates side panel are the same size as main panels. \code{.x} will set the scale for the xside panel
and \code{.y} will set the scale for the yside panel. \cr
\tab \cr
\code{ggside.panel.spacing, ggside.panel.spacing.x, ggside.panel.spacing.y} \tab expects a scalar unit
that sets the spacing between side panels and main panels. Default facet spacing is typically
\code{unit(5.5,"pt")} whereas this element's default is \code{unit(2,"pt")} to indicate the relationship
a side panel has to the main panels. \code{.x} will set the space between the main panel and the yside panel,
where as \code{.y} will set the space between the main panel and the xside panel. \cr
\tab \cr
\code{ggside.panel.background} \tab Sets the background of the side panels. If unspecified, side panels
inherit from \code{panel.background} \cr
\tab \cr
\code{ggside.panel.grid, ggside.panel.grid.major, ggside.panel.grid.minor,
ggside.panel.grid.major.x, ggside.panel.grid.major.y, ggside.panel.grid.minor.x, ggside.panel.grid.minor.y}
\tab
Grid lines for the side panels. These elements inherit from \code{panel.grid} and will default
to the current theme's \code{panel.grid} inheritance unless specifically set. \cr
\tab \cr
\code{ggside.axis.text, ggside.axis.text.x, ggside.axis.text.y,
 ggside.axis.text.x.top, ggside.axis.text.x.bottom, ggside.axis.text.y.left, ggside.axis.text.y.right} \tab
Tick labels along the side panel's axis. Due to the layout of side panels, \code{ggside.axis.text.x}
will only affect the yside panel's x-axis text and \code{ggside.axis.text.y} will
only affect the xside panel's y-axis text. These elements inherit from \code{axis.text}
and will default to the current theme's \code{axis.text} inheritance scheme unless
specifically set. \cr
\tab \cr
\code{ggside.axis.line, ggside.axis.line.x, ggside.axis.line.y,
ggside.axis.line.x.top, ggside.axis.line.x.bottom, ggside.axis.line.y.left, ggside.axis.line.y.right} \tab
Lines along the side panel's axis.Due to the layout of side panels, \code{ggside.axis.line.x}
will only affect the yside panel's x-axis text and \code{ggside.axis.line.y} will
only affect the xside panel's y-axis text. Theme elements inherit from \code{axis.line}
and will default to the current theme's \code{axis.line} inheritance scheme unless
specifically set. \cr
\tab \cr
\code{ggside.axis.ticks, ggside.axis.ticks.x, ggside.axis.ticks.y,
ggside.axis.ticks.x.top, ggside.axis.ticks.x.bottom, ggside.axis.ticks.y.left, ggside.axis.ticks.y.right} \tab
Tick marks along the side panel's axis. Due to the layout of side panels, \code{ggside.axis.ticks.x}
will only affect the yside panel's x-axis text and \code{ggside.axis.ticks.y} will
only affect the xside panel's y-axis text. Theme elements inherit from \code{axis.ticks}
and will default to the current theme's \code{axis.ticks} inheritance scheme unless
specifically set. \cr
\tab \cr
\code{ggside.axis.ticks.length, ggside.axis.ticks.length.x,
ggside.axis.ticks.length.y, ggside.axis.ticks.length.x.top, ggside.axis.ticks.length.x.bottom,
ggside.axis.ticks.length.y.left, ggside.axis.ticks.length.y.right} \tab
length of ticks along the side panel's axis. Due to the layout of side panels, \code{ggside.axis.ticks.length.x}
will only affect the yside panel's x-axis text and \code{ggside.axis.ticks.length.y} will
only affect the xside panel's y-axis text. Theme elements inherit from \code{axis.ticks.length}
and will default to the current theme's \code{axis.ticks.length} inheritance scheme unless
specifically set. \cr
\tab \cr
\code{ggside.axis.minor.ticks, ggside.axis.minor.ticks.x, ggside.axis.minor.ticks.y,
ggside.axis.minor.ticks.x.top, ggside.axis.minor.ticks.x.bottom, ggside.axis.minor.ticks.y.left, ggside.axis.minor.ticks.y.right} \tab
Tick marks along the side panel's axis. Due to the layout of side panels, \code{ggside.axis.minor.ticks.x}
will only affect the yside panel's x-axis text and \code{ggside.axis.minor.ticks.y} will
only affect the xside panel's y-axis text. Theme elements inherit from \code{axis.minor.ticks}
and will default to the current theme's \code{axis.minor.ticks} inheritance scheme unless
specifically set. \cr
\tab \cr
\code{ggside.axis.minor.ticks.length, ggside.axis.minor.ticks.length.x,
ggside.axis.minor.ticks.length.y, ggside.axis.minor.ticks.length.x.top, ggside.axis.minor.ticks.length.x.bottom,
ggside.axis.minor.ticks.length.y.left, ggside.axis.minor.ticks.length.y.right} \tab
length of minor ticks along the side panel's axis. Due to the layout of side panels, \code{ggside.axis.minor.ticks.length.x}
will only affect the yside panel's x-axis text and \code{ggside.axis.minor.ticks.length.y} will
only affect the xside panel's y-axis text. Theme elements inherit from \code{axis.minor.ticks.length}
and will default to the current theme's \code{axis.minor.ticks.length} inheritance scheme unless
specifically set. \cr
\tab \cr
}
}

\examples{

library(ggplot2)
library(ggside)

p <- ggplot(iris, aes(Sepal.Width, Petal.Length, color = Species)) +
  geom_point() +
  geom_xsidedensity() +
  geom_ysidedensity() +
  theme_dark()

p

p + theme_ggside_classic()
p + theme_ggside_void()
p + theme_ggside_linedraw() +
  theme(ggside.panel.border = element_rect(colour = "red"))
}
