% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggwithinstats.R
\name{ggwithinstats}
\alias{ggwithinstats}
\title{Box/Violin plots for repeated measures comparisons}
\usage{
ggwithinstats(
  data,
  x,
  y,
  type = "parametric",
  pairwise.display = "significant",
  p.adjust.method = "holm",
  effsize.type = "unbiased",
  bf.prior = 0.707,
  bf.message = TRUE,
  results.subtitle = TRUE,
  xlab = NULL,
  ylab = NULL,
  caption = NULL,
  title = NULL,
  subtitle = NULL,
  digits = 2L,
  conf.level = 0.95,
  nboot = 100L,
  tr = 0.2,
  centrality.plotting = TRUE,
  centrality.type = type,
  centrality.point.args = list(size = 5, color = "darkred"),
  centrality.label.args = list(size = 3, nudge_x = 0.4, segment.linetype = 4),
  centrality.path = TRUE,
  centrality.path.args = list(linewidth = 1, color = "red", alpha = 0.5),
  point.args = list(size = 3, alpha = 0.5, na.rm = TRUE),
  point.path = TRUE,
  point.path.args = list(alpha = 0.5, linetype = "dashed"),
  boxplot.args = list(width = 0.2, alpha = 0.5, na.rm = TRUE),
  violin.args = list(width = 0.5, alpha = 0.2, na.rm = TRUE),
  ggsignif.args = list(textsize = 3, tip_length = 0.01, na.rm = TRUE),
  ggtheme = ggstatsplot::theme_ggstatsplot(),
  package = "RColorBrewer",
  palette = "Dark2",
  ggplot.component = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{x}{The grouping (or independent) variable from \code{data}. In case of a
repeated measures or within-subjects design, if \code{subject.id} argument is
not available or not explicitly specified, the function assumes that the
data has already been sorted by such an id by the user and creates an
internal identifier. So if your data is \strong{not} sorted, the results \emph{can}
be inaccurate when there are more than two levels in \code{x} and there are
\code{NA}s present. The data is expected to be sorted by user in
subject-1, subject-2, ..., pattern.}

\item{y}{The response (or outcome or dependent) variable from \code{data}.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{pairwise.display}{Decides \emph{which} pairwise comparisons to display.
Available options are:
\itemize{
\item \code{"significant"} (abbreviation accepted: \code{"s"})
\item \code{"non-significant"} (abbreviation accepted: \code{"ns"})
\item \code{"all"}
}

You can use this argument to make sure that your plot is not uber-cluttered
when you have multiple groups being compared and scores of pairwise
comparisons being displayed. If set to \code{"none"}, no pairwise comparisons
will be displayed.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"eta"} (partial eta-squared) or \code{"omega"} (partial
omega-squared).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of \code{1/2}, \code{sqrt(2)/2}, and \code{1}, respectively. In case of an ANOVA, this
value corresponds to scale for fixed effects.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{xlab}{Label for \code{x} axis variable. If \code{NULL} (default),
variable name for \code{x} will be used.}

\item{ylab}{Labels for \code{y} axis variable. If \code{NULL} (default),
variable name for \code{y} will be used.}

\item{caption}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{conf.level}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100L}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{centrality.plotting}{Logical that decides whether centrality tendency
measure is to be displayed as a point with a label (Default: \code{TRUE}).
Function decides which central tendency measure to show depending on the
\code{type} argument.
\itemize{
\item \strong{mean} for parametric statistics
\item \strong{median} for non-parametric statistics
\item \strong{trimmed mean} for robust statistics
\item \strong{MAP estimator} for Bayesian statistics
}

If you want default centrality parameter, you can specify this using
\code{centrality.type} argument.}

\item{centrality.type}{Decides which centrality parameter is to be displayed.
The default is to choose the same as \code{type} argument. You can specify this
to be:
\itemize{
\item \code{"parameteric"} (for \strong{mean})
\item \code{"nonparametric"} (for \strong{median})
\item \code{robust} (for \strong{trimmed mean})
\item \code{bayes} (for \strong{MAP estimator})
}

Just as \code{type} argument, abbreviations are also accepted.}

\item{centrality.point.args, centrality.label.args}{A list of additional aesthetic
arguments to be passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}} and
\code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}} geoms, which are involved in mean plotting.}

\item{centrality.path.args, point.path.args}{A list of additional aesthetic
arguments passed on to \code{\link[ggplot2:geom_path]{ggplot2::geom_path()}} connecting raw data points
and mean points.}

\item{point.args}{A list of additional aesthetic arguments to be passed to
the \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}

\item{point.path, centrality.path}{Logical that decides whether individual
data points and means, respectively, should be connected using
\code{\link[ggplot2:geom_path]{ggplot2::geom_path()}}. Both default to \code{TRUE}. Note that \code{point.path}
argument is relevant only when there are two groups (i.e., in case of a
\emph{t}-test). In case of large number of data points, it is advisable to set
\code{point.path = FALSE} as these lines can overwhelm the plot.}

\item{boxplot.args}{A list of additional aesthetic arguments passed on to
\code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}. By default, the whiskers extend to 1.5 times
the interquartile range (IQR) from the box (Tukey-style). To customize
whisker length, you can use the \code{coef} parameter, e.g.,
\code{boxplot.args = list(coef = 3)} for whiskers extending to 3 * IQR, or
\code{boxplot.args = list(coef = 0)} to show only the range of the data.}

\item{violin.args}{A list of additional aesthetic arguments to be passed to
the \code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}}.}

\item{ggsignif.args}{A list of additional aesthetic
arguments to be passed to \code{\link[ggsignif:stat_signif]{ggsignif::geom_signif()}}.}

\item{ggtheme}{A \code{{ggplot2}} theme. Default value is
\code{\link[=theme_ggstatsplot]{theme_ggstatsplot()}}. Any of the \code{{ggplot2}} themes (e.g.,
\code{\link[ggplot2:ggtheme]{ggplot2::theme_bw()}}), or themes from extension packages are allowed
(e.g., \code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()},
etc.). But note that sometimes these themes will remove some of the details
that \code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{\link[=ggbetweenstats]{ggbetweenstats()}} shows details about multiple comparison test as a
label on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}

\item{package, palette}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{{ggstatsplot}}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{{ggplot2}} function or a list of \code{{ggplot2}} functions.}

\item{...}{Currently ignored.}
}
\description{
A combination of box and violin plots along with raw (unjittered) data points
for within-subjects designs with statistical details included in the plot as
a subtitle.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggwithinstats.html}
}
\section{Summary of graphics}{
\tabular{lll}{
   graphical element \tab \code{geom} used \tab argument for further modification \cr
   raw data \tab \code{ggplot2::geom_point()} \tab \code{point.args} \cr
   point path \tab \code{ggplot2::geom_path()} \tab \code{point.path.args} \cr
   box plot \tab \code{ggplot2::geom_boxplot()} \tab \code{boxplot.args} \cr
   density plot \tab \code{ggplot2::geom_violin()} \tab \code{violin.args} \cr
   centrality measure point \tab \code{ggplot2::geom_point()} \tab \code{centrality.point.args} \cr
   centrality measure point path \tab \code{ggplot2::geom_path()} \tab \code{centrality.path.args} \cr
   centrality measure label \tab \code{ggrepel::geom_label_repel()} \tab \code{centrality.label.args} \cr
   pairwise comparisons \tab \code{ggsignif::geom_signif()} \tab \code{ggsignif.args} \cr
}
}

\section{Centrality measures}{



The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}\tabular{lll}{
   Type \tab Measure \tab Function used \cr
   Parametric \tab mean \tab \code{datawizard::describe_distribution()} \cr
   Non-parametric \tab median \tab \code{datawizard::describe_distribution()} \cr
   Robust \tab trimmed mean \tab \code{datawizard::describe_distribution()} \cr
   Bayesian \tab MAP \tab \code{datawizard::describe_distribution()} \cr
}

}

\section{Two-sample tests}{



The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}
\subsection{between-subjects}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab No. of groups \tab Test \tab Function used \cr
   Parametric \tab 2 \tab Student's or Welch's \emph{t}-test \tab \code{stats::t.test()} \cr
   Non-parametric \tab 2 \tab Mann-Whitney \emph{U} test \tab \code{stats::wilcox.test()} \cr
   Robust \tab 2 \tab Yuen's test for trimmed means \tab \code{WRS2::yuen()} \cr
   Bayesian \tab 2 \tab Student's \emph{t}-test \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}\tabular{lllll}{
   Type \tab No. of groups \tab Effect size \tab CI available? \tab Function used \cr
   Parametric \tab 2 \tab Cohen's \emph{d}, Hedge's \emph{g} \tab Yes \tab \code{effectsize::cohens_d()}, \code{effectsize::hedges_g()} \cr
   Non-parametric \tab 2 \tab \emph{r} (rank-biserial correlation) \tab Yes \tab \code{effectsize::rank_biserial()} \cr
   Robust \tab 2 \tab Algina-Keselman-Penfield robust standardized difference \tab Yes \tab \code{WRS2::akp.effect()} \cr
   Bayesian \tab 2 \tab difference \tab Yes \tab \code{bayestestR::describe_posterior()} \cr
}

}

\subsection{within-subjects}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab No. of groups \tab Test \tab Function used \cr
   Parametric \tab 2 \tab Student's \emph{t}-test \tab \code{stats::t.test()} \cr
   Non-parametric \tab 2 \tab Wilcoxon signed-rank test \tab \code{stats::wilcox.test()} \cr
   Robust \tab 2 \tab Yuen's test on trimmed means for dependent samples \tab \code{WRS2::yuend()} \cr
   Bayesian \tab 2 \tab Student's \emph{t}-test \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}\tabular{lllll}{
   Type \tab No. of groups \tab Effect size \tab CI available? \tab Function used \cr
   Parametric \tab 2 \tab Cohen's \emph{d}, Hedge's \emph{g} \tab Yes \tab \code{effectsize::cohens_d()}, \code{effectsize::hedges_g()} \cr
   Non-parametric \tab 2 \tab \emph{r} (rank-biserial correlation) \tab Yes \tab \code{effectsize::rank_biserial()} \cr
   Robust \tab 2 \tab Algina-Keselman-Penfield robust standardized difference \tab Yes \tab \code{WRS2::wmcpAKP()} \cr
   Bayesian \tab 2 \tab difference \tab Yes \tab \code{bayestestR::describe_posterior()} \cr
}

}

}

\section{One-way ANOVA}{



The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}
\subsection{between-subjects}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab No. of groups \tab Test \tab Function used \cr
   Parametric \tab > 2 \tab Fisher's or Welch's one-way ANOVA \tab \code{stats::oneway.test()} \cr
   Non-parametric \tab > 2 \tab Kruskal-Wallis one-way ANOVA \tab \code{stats::kruskal.test()} \cr
   Robust \tab > 2 \tab Heteroscedastic one-way ANOVA for trimmed means \tab \code{WRS2::t1way()} \cr
   Bayes Factor \tab > 2 \tab Fisher's ANOVA \tab \code{BayesFactor::anovaBF()} \cr
}


\strong{Effect size estimation}\tabular{lllll}{
   Type \tab No. of groups \tab Effect size \tab CI available? \tab Function used \cr
   Parametric \tab > 2 \tab partial eta-squared, partial omega-squared \tab Yes \tab \code{effectsize::omega_squared()}, \code{effectsize::eta_squared()} \cr
   Non-parametric \tab > 2 \tab rank epsilon squared \tab Yes \tab \code{effectsize::rank_epsilon_squared()} \cr
   Robust \tab > 2 \tab Explanatory measure of effect size \tab Yes \tab \code{WRS2::t1way()} \cr
   Bayes Factor \tab > 2 \tab Bayesian R-squared \tab Yes \tab \code{performance::r2_bayes()} \cr
}

}

\subsection{within-subjects}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab No. of groups \tab Test \tab Function used \cr
   Parametric \tab > 2 \tab One-way repeated measures ANOVA \tab \code{afex::aov_ez()} \cr
   Non-parametric \tab > 2 \tab Friedman rank sum test \tab \code{stats::friedman.test()} \cr
   Robust \tab > 2 \tab Heteroscedastic one-way repeated measures ANOVA for trimmed means \tab \code{WRS2::rmanova()} \cr
   Bayes Factor \tab > 2 \tab One-way repeated measures ANOVA \tab \code{BayesFactor::anovaBF()} \cr
}


\strong{Effect size estimation}\tabular{lllll}{
   Type \tab No. of groups \tab Effect size \tab CI available? \tab Function used \cr
   Parametric \tab > 2 \tab partial eta-squared, partial omega-squared \tab Yes \tab \code{effectsize::omega_squared()}, \code{effectsize::eta_squared()} \cr
   Non-parametric \tab > 2 \tab Kendall's coefficient of concordance \tab Yes \tab \code{effectsize::kendalls_w()} \cr
   Robust \tab > 2 \tab Algina-Keselman-Penfield robust standardized difference average \tab Yes \tab \code{WRS2::wmcpAKP()} \cr
   Bayes Factor \tab > 2 \tab Bayesian R-squared \tab Yes \tab \code{performance::r2_bayes()} \cr
}

}

}

\section{Pairwise comparison tests}{



The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}
\subsection{between-subjects}{

\strong{Hypothesis testing}\tabular{lllll}{
   Type \tab Equal variance? \tab Test \tab \emph{p}-value adjustment? \tab Function used \cr
   Parametric \tab No \tab Games-Howell test \tab Yes \tab \code{PMCMRplus::gamesHowellTest()} \cr
   Parametric \tab Yes \tab Student's \emph{t}-test \tab Yes \tab \code{stats::pairwise.t.test()} \cr
   Non-parametric \tab No \tab Dunn test \tab Yes \tab \code{PMCMRplus::kwAllPairsDunnTest()} \cr
   Robust \tab No \tab Yuen's trimmed means test \tab Yes \tab \code{WRS2::lincon()} \cr
   Bayesian \tab \code{NA} \tab Student's \emph{t}-test \tab \code{NA} \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}

Not supported.
}

\subsection{within-subjects}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab Test \tab \emph{p}-value adjustment? \tab Function used \cr
   Parametric \tab Student's \emph{t}-test \tab Yes \tab \code{stats::pairwise.t.test()} \cr
   Non-parametric \tab Durbin-Conover test \tab Yes \tab \code{PMCMRplus::durbinAllPairsTest()} \cr
   Robust \tab Yuen's trimmed means test \tab Yes \tab \code{WRS2::rmmcp()} \cr
   Bayesian \tab Student's \emph{t}-test \tab \code{NA} \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}

Not supported.
}

}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && requireNamespace("afex", quietly = TRUE)) withAutoprint(\{ # examplesIf}
# for reproducibility
set.seed(123)
library(dplyr, warn.conflicts = FALSE)

# create a plot
p <- ggwithinstats(
  data = filter(bugs_long, condition \%in\% c("HDHF", "HDLF")),
  x    = condition,
  y    = desire,
  type = "np"
)


# looking at the plot
p

# extracting details from statistical tests
extract_stats(p)

# modifying defaults
ggwithinstats(
  data = bugs_long,
  x    = condition,
  y    = desire,
  type = "robust"
)

# you can remove a specific geom to reduce complexity of the plot
ggwithinstats(
  data = bugs_long,
  x = condition,
  y = desire,
  # to remove violin plot
  violin.args = list(width = 0, linewidth = 0, colour = NA),
  # to remove boxplot
  boxplot.args = list(width = 0),
  # to remove points
  point.args = list(alpha = 0)
)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{grouped_ggbetweenstats}}, \code{\link{ggbetweenstats}},
\code{\link{grouped_ggwithinstats}}
}
