% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simTTE.R
\name{simTTE}
\alias{simTTE}
\title{Simulate an \code{hce} dataset with two correlated outcomes (illness - death model)}
\usage{
simTTE(
  n,
  n0 = n,
  TTE_A,
  TTE_P = TTE_A,
  shape = 1,
  shape0 = shape,
  fixedfy = 2,
  theta = 1,
  alpha0 = 1,
  alpha = 1,
  rHR = 1
)
}
\arguments{
\item{n}{sample size in the active treatment group.}

\item{n0}{sample size in the placebo treatment group.}

\item{TTE_A}{event rates in the active group for the time-to-event outcomes; a numeric vector of length two.}

\item{TTE_P}{event rates in the placebo group for the time-to-event outcomes; a numeric vector of length two.}

\item{shape}{shape parameter of the Weibull distribution for time-to-event outcomes in the active group. Default is 1 (exponential distribution).}

\item{shape0}{shape parameter of the Weibull distribution for time-to-event outcomes in the placebo group. Default is 1 (exponential distribution).}

\item{fixedfy}{length of follow-up.}

\item{theta}{heterogeneity coefficient for the first event, modeled via a gamma distribution with mean 1; \code{theta} controls the variance. When \code{theta = 0}, there is no heterogeneity, which implies that death and hospitalization are independent.}

\item{alpha0}{exponential heterogeneity coefficient for modeling the heterogeneity of risk of death as the first event.}

\item{alpha}{exponential heterogeneity coefficient for modeling the heterogeneity of risk of death after hospitalization; the heterogeneity of the second event is the inverse of the time of the first event.}

\item{rHR}{recurrence hazard ratio comparing the active group to the control group for the second event, based on gap time measured from the first event.}
}
\value{
an object of class \code{hce}.
}
\description{
Simulate an \code{hce} dataset with two correlated outcomes - death and hospitalization - from a heterogeneous population. The correlation between these outcomes arises from population heterogeneity. Models the risk of death following hospitalization as dependent on the timing
of the hospitalization, reflecting strong dependence between the times to the first and second events (i.e., event clustering).
}
\details{
The default setting assumes \code{TTE_A = TTE_P}. Both \code{TTE_A} and \code{TTE_P} must be numeric vectors of length two, corresponding to the event rates
(Weibull distribution) for the first event of hospitalization and death. The parameters \code{shape} and \code{shape0} identify the shape parameters
of Weibull distributions for the first event, simulated from a distribution with a cumulative hazard of \verb{rate × gamma × t^shape} for
hospitalization and \verb{gamma^alpha0 × rate × t^shape} for death, where \code{gamma} is a patient-specific frailty drawn from a gamma distribution with mean 1 and
variance \code{theta}, shared between death and hospitalization for a given patient. The parameter \code{theta} represents population heterogeneity and also induces
correlation between death and hospitalization as competing first events. The parameter \code{alpha0} controls the heterogeneity of time to death through its
effect on heterogeneity. Death after hospitalization is simulated from an exponential distribution with a constant hazard that depends on the timing \code{t1}
of the first event (hospitalization) as \verb{(average provided first-death rate) × (t1  / fixedfy)^alpha × gamma^alpha0} for the placebo arm and \verb{(average provided first-death rate) × rHR × (t1  / fixedfy)^alpha × gamma^alpha0} for the active arm where \code{rHR} is the recurrence
hazard ratio. When \code{alpha < 0}, earlier hospitalization (smaller \code{t1})
increases the risk of death following hospitalization.
}
\examples{
## Example - positive correlation
i <- 1764002323
set.seed(i)
PADY <- 2
D <- simTTE(n = 1000, TTE_A = c(0.1, 0.04), 
TTE_P = c(.15, 0.045), theta = 4, alpha0 = 2, alpha = -1, shape = 2, 
fixedfy = PADY, rHR = 1)
####### Summary of first events by treatment group ########
table(D$EVENT1, D$TRTP)
####### Summary of second events by treatment group ########
table(D$EVENT2, D$TRTP)
######## Calculate win odds #########################
calcWO(D, ref = "P")
## Plot the ordinal dominance graph ######
D$TRTP <- factor(D$TRTP, levels = c("P", "A"))
plot(D, type = "l", col = 2, fill = TRUE)
abline(a = 0, b = 1, lwd = 2, lty = 3, col = "darkgreen")
grid()

}
\seealso{
\code{\link[=simHCE]{simHCE()}} for a general \code{hce} dataset simulation, and \code{\link[=simKHCE]{simKHCE()}} for kidney disease-specific \code{hce} simulation.
}
