% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collocation_plot.R
\name{collocation_plot}
\alias{collocation_plot}
\title{Map collocation to ggplot object}
\usage{
collocation_plot(
  frequency_doc,
  n_scenario = 1,
  colors = c("#f251fc", "#f8ff1b")
)
}
\arguments{
\item{frequency_doc}{document of frequencies (returned from
\code{\link[=transcript_frequency]{transcript_frequency()}})}

\item{n_scenario}{number of scenarios for which this transcript appeared. Defualt is 1}

\item{colors}{list for color specification for the gradient. Default is c("#f251fc","#f8ff1b")}
}
\value{
list of plot, plot object, and frequency
}
\description{
This assigns colors based on frequency to the words in the transcript.
}
\examples{
# Rename relevant column to page_notes in the derivative document
comment_example_rename <- dplyr::rename(comment_example, page_notes=Notes)
# Tokenize the derivative document
toks_comment <- token_comments(comment_example_rename)
# Rename relevant column in the source document to text
transcript_example_rename <- dplyr::rename(transcript_example, text=Text)
# Tokenize source document
toks_transcript <- token_transcript(transcript_example_rename)
# Compute collocation frequencies
collocation_object <- collocate_comments(toks_transcript, toks_comment)
# Merge frequencies with source document to provide averages by word and correct formatting
merged_frequency <- transcript_frequency(transcript_example_rename, collocation_object)
# Create a plot object to assign colors based on frequency
freq_plot <- collocation_plot(merged_frequency)
}
