% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iPRSue_estimates_BT.R
\name{iPRSue_estimates_BT}
\alias{iPRSue_estimates_BT}
\title{iPRSue_estimates_BT function}
\usage{
iPRSue_estimates_BT(
  gwas,
  target_pheno,
  target_geno_mat,
  no_of_PRSs = 500,
  significance_level = 0.05,
  seed = NULL
)
}
\arguments{
\item{gwas}{A data frame with GWAS summary statistics for binary traits. Must contain \code{beta} and \code{se} columns representing
estimated SNP effect sizes and their standard errors.}

\item{target_pheno}{Character. Path to the target phenotype file. Assumes no header and individual IDs in the second column.}

\item{target_geno_mat}{Character. Path to the genotype matrix of target individuals. No header is expected; columns correspond to SNPs.}

\item{no_of_PRSs}{Integer. Number of simulations used to construct PRS uncertainty intervals. Default is 500.}

\item{significance_level}{Numeric. Significance level for confidence intervals (e.g., 0.05 gives 95\% CI). Default is 0.05.}

\item{seed}{Integer or NULL. Random seed for reproducibility. If NULL, results may vary across runs. Default is NULL.}
}
\value{
A data frame containing the following columns:
\describe{
\item{IID}{Individual identifier (from target phenotype file).}
\item{PRS}{Mean of simulated PRSs for each individual.}
\item{Variance}{Variance across simulated PRSs.}
\item{Lower_Limit}{Lower bound of the confidence interval.}
\item{Upper_Limit}{Upper bound of the confidence interval.}
}
}
\description{
Computes individual-level polygenic risk scores (PRS) with uncertainty estimates using a simulation-based approach
for binary traits. This implementation follows the iPRSue framework, simulating multiple PRSs by sampling from
the GWAS effect size distribution and deriving individual-level confidence intervals.
}
\details{
For each SNP, the function simulates \code{no_of_PRSs} effect sizes from a normal distribution defined by its GWAS beta and SE.
These sampled betas are multiplied by the genotype matrix to generate PRS replicates for each individual.
Confidence intervals are then calculated using the specified significance level.

This function is designed for binary traits and should be used with GWAS summary statistics obtained from logistic regression.
}
\examples{
\dontrun{
  # Step 1: Run GWAS on binary trait
  results <- GWAS_BT(
    plink_path = "./plink2",
    b_file = "./binary_file_prefix",
    discovery_pheno = "./discovery_phenotype_file",
    discovery_cov = "./discovery_covariate_file",
    thread = 48
  )
  
  # Step 2: Estimate individual PRS with uncertainty
  bpt <- system.file("Bpt.txt", package = "iPRSue", mustWork = TRUE)
  gt  <- system.file("Gt.txt",  package = "iPRSue", mustWork = TRUE)
  
  prs_estimates <- iPRSue_estimates_BT(
    gwas              = results,
    target_pheno      = bpt,
    target_geno_mat   = gt,
    no_of_PRSs        = 500,
    significance_level = 0.05,
    seed              = 123
  )
  head(prs_estimates)
}

}
