% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_clustering.R
\name{immunr_hclust}
\alias{immunr_hclust}
\alias{immunr_kmeans}
\alias{immunr_dbscan}
\title{Clustering of objects or distance matrices}
\usage{
immunr_hclust(.data, .k = 2, .k.max = nrow(.data) - 1, .method = "complete", .dist = TRUE)

immunr_kmeans(.data, .k = 2, .k.max = as.integer(sqrt(nrow(.data))) + 1,
.method = c("silhouette", "gap_stat"))

immunr_dbscan(.data, .eps, .dist = TRUE)
}
\arguments{
\item{.data}{Matrix or data frame with features, distance matrix or output from \link{repOverlapAnalysis} or \link{geneUsageAnalysis} functions.}

\item{.k}{The number of clusters to create, defined as \code{k} to \link[factoextra:hcut]{hcut} or as \code{centers} to \link{kmeans}.}

\item{.k.max}{Limits the maximum number of clusters. It is passed as \code{k.max} to \link[factoextra:fviz_nbclust]{factoextra::fviz_nbclust} for \code{immunr_hclust} and \code{immunr_kmeans}.}

\item{.method}{Passed to \link[factoextra:hcut]{factoextra::hcut} or as \link[factoextra:fviz_nbclust]{factoextra::fviz_nbclust}.

In case of \link[factoextra:hcut]{factoextra::hcut} the agglomeration method is going to be used (argument \code{hc_method}).

In case of \link[factoextra:fviz_nbclust]{factoextra::fviz_nbclust} it is the method to be used for estimating the optimal number of clusters (argument \code{method}).}

\item{.dist}{If TRUE then ".data" is expected to be a distance matrix. If FALSE then the euclidean distance is computed for the input objects.}

\item{.eps}{Local radius for expanding clusters, minimal distance between points to expand clusters. Passed as \code{eps} to \link[fpc:dbscan]{dbscan}.}
}
\value{
\code{immunr_hclust} - list with two elements. The first element is an output from \link[factoextra:hcut]{factoextra::hcut}.
The second element is an output from \link[factoextra:fviz_nbclust]{factoextra::fviz_nbclust}

\code{immunr_kmeans} - list with three elements. The first element is an output from \link{kmeans}.
The second element is an output from \link[factoextra:fviz_nbclust]{factoextra::fviz_nbclust}.
The third element is the input dataset \code{.data}.

\code{immunr_dbscan} - list with two elements. The first element is an output from \link[fpc:dbscan]{fpc::dbscan}.
The second element is the input dataset \code{.data}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Clusters the data with one of the following methods:
\itemize{
\item \code{immunr_hclust} clusters the data using the hierarchical clustering from \link[factoextra:hcut]{hcut};
\item \code{immunr_kmeans} clusters the data using the K-means algorithm from \link{kmeans};
\item \code{immunr_dbscan} clusters the data using the DBSCAN algorithm from \link[fpc:dbscan]{dbscan}.
}
}
\examples{
data(immdata)
gu <- geneUsage(immdata$data, .norm = TRUE)
immunr_hclust(t(as.matrix(gu[, -1])), .dist = FALSE)

gu[is.na(gu)] <- 0
immunr_kmeans(t(as.matrix(gu[, -1])))
}
\concept{post_analysis}
