
css_combine <- function(stylesheet, file = stdout()) {

  bundle <- vapply(stylesheet, read_lines,
                   FUN.VALUE = character(1), USE.NAMES = FALSE)
  compiled <- sass::sass(bundle)

  cat("/* CSS generated by juicedown */\n\n", file = file)
  cat(compiled, file = file, append = TRUE, sep = "\n")
}

css_find <- function(stylesheets) {
  user_file <- file.exists(stylesheets)

  if (any(!user_file)) {
    system_file <- pkg_file("css", stylesheets[!user_file])
    stylesheets[!user_file] <- system_file
  }
  stylesheets
}



