% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-class.R
\docType{class}
\name{lba-class}
\alias{lba-class}
\alias{setLBA}
\title{An S4 Class of the \code{lba} Object}
\usage{
setLBA(model, population_distribution = NULL, is_positive_drift = TRUE)
}
\arguments{
\item{model}{A model object containing the model specification}

\item{population_distribution}{Optional population distribution for
parameters (default \code{NULL})}

\item{is_positive_drift}{a Boolean value indicating whether to use strictly
positive drift rates}
}
\value{
An object of class lba containing:
\itemize{
\item The model specification
\item Population distribution (if provided)
\item Node 1 index information
\item Whether to restrict drift rates to be positive
}
}
\description{
The \code{lba} class represents an LBA model with slots for model
specification, population distribution, and other necessary components.
The \code{setLBA} function is the constructor for creating \code{lba}
objects.
}
\details{
The LBA model is a popular decision-making model that assumes evidence
accumulates linearly toward decision thresholds. The setLBA function
initialises this model by creating an S4 object with all necessary
components, including automatically calculating node 1 indices and
creating an indicator vector to inform whether to use strictly positive
drift rates.
}
\section{Slots}{

\describe{
\item{\code{model}}{A model object containing the model specification}

\item{\code{population_distribution}}{The population distribution for parameters
(can be NULL)}

\item{\code{node_1_index}}{Index information for the first node (automatically
calculated)}

\item{\code{is_positive_drift}}{Logical vector indicating positive drift for each
accumulator}
}}

