% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorchecks.R
\name{summary_hfv}
\alias{summary_hfv}
\title{Summary of Classes "hfvdata" and "hfvlist}
\usage{
summary_hfv(
  object,
  popid = "popid",
  patchid = "patchid",
  individ = "individ",
  year2id = "year2",
  full = FALSE,
  err_check = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of either class \code{hfvdata} or class
\code{hfvlist}.}

\item{popid}{A string denoting the name of the variable denoting population
identity.}

\item{patchid}{A string denoting the name of the variable denoting patch
identity.}

\item{individ}{A string denoting the name of the variable denoting individual
identity.}

\item{year2id}{A string denoting the name of the variable denoting the year
in time \emph{t}.}

\item{full}{A logical value indicating whether to include basic data frame
summary information in addition to hfvdata-specific summary information.
Defaults to \code{FALSE}.}

\item{err_check}{A logical value indicating whether to check for errors in
stage assignment.}

\item{...}{Other parameters.}
}
\value{
A summary of the object. If an object of class \code{hfvdata} is
entered, then the first line of output shows the numbers of populations,
patches, individuals, and time steps. If \code{full = TRUE}, then this is
followed by a standard data frame summary of the hfv dataset. If
\code{err_check = TRUE}, then a subset of the original data frame input as
\code{object} is exported with only rows showing stage assignment issues.

If an object of class \code{hfvlist} in entered, then the first line of
output shows the number of bootstrapped datasets. This is followed by lines
showing the mean number of rows and variables per data frame, as well as the
mean numbers of populations, patches, individuals, and years per data frame.
This is followed by lines showing the total number of unique populations,
patches, individuals, and years sampled across the bootstrapped data frames.
If \code{full = TRUE}, then this is followed by standard data frame summaries
of all bootstrapped data frames. If \code{err_check = TRUE}, then a data
frame is output with all of the problem rows across all bootstrapped data
frames, starting with a new variable giving the bootstrap number of origin.
}
\description{
A function to simplify the viewing of basic information describing
demographic data in historical vertical format (data frames of class
\code{hfvdata}, or bootstrapped data frames in lists of class
\code{hfvlist}).
}
\section{Notes}{

Stage assignment issue identified by option \code{err_check} fall under two
categories. First, all rows showing \code{NoMatch} as the identified stage
for \code{stage1}, \code{stage2}, or \code{stage3} are identified. Second,
all rows showing \code{stage1 = "NotAlive"} and \code{alive1 = 1},
\code{stage2 = "NotAlive"} and \code{alive2 = 1}, or
\code{stage3 = "NotAlive"} and \code{alive3 = 1} are identified.
}

\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypraw_v1 <- verticalize3(data = cypdata, noyears = 6, firstyear = 2004,
  patchidcol = "patch", individcol = "plantid", blocksize = 4,
  sizeacol = "Inf2.04", sizebcol = "Inf.04", sizeccol = "Veg.04",
  repstracol = "Inf.04", repstrbcol = "Inf2.04", fecacol = "Pod.04",
  stageassign = cypframe_raw, stagesize = "sizeadded", NAas0 = TRUE,
  NRasRep = TRUE)

summary_hfv(cypraw_v1)

cypraw_v1_boot <- bootstrap3(cypraw_v1, reps = 3)

summary_hfv(cypraw_v1_boot)

}
