% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main-plot_pred.R
\name{plot_pred}
\alias{plot_pred}
\alias{plot_f}
\title{Visualizing model predictions or inferred covariate effects}
\usage{
plot_pred(
  fit,
  pred = NULL,
  group_by = "id",
  t_name = "age",
  MULT_STD = 2,
  verbose = TRUE,
  draws = NULL,
  reduce = function(x) base::mean(x),
  x = NULL,
  ...
)

plot_f(
  fit,
  pred = NULL,
  group_by = "id",
  t_name = "age",
  MULT_STD = 2,
  verbose = TRUE,
  draws = NULL,
  reduce = function(x) base::mean(x),
  comp_idx = NULL,
  color_by = NA,
  x = NULL,
  ...
)
}
\arguments{
\item{fit}{An object of class \linkS4class{lgpfit}.}

\item{pred}{An object of class \linkS4class{GaussianPrediction} or
\linkS4class{Prediction}. If \code{pred=NULL}, the \code{\link{pred}}
function is called with the given \code{reduce} and \code{draws} arguments.}

\item{group_by}{name of the grouping variable (use \code{group_by=NA}
to avoid grouping)}

\item{t_name}{name of the x-axis variable}

\item{MULT_STD}{a multiplier for standard deviation}

\item{verbose}{Can this print any messages?}

\item{draws}{Only has effect if \code{pred=NULL}.}

\item{reduce}{Only has effect if \code{pred=NULL}.}

\item{x}{Deprecated argument. This is now taken from the \code{pred}
object to ensure compatibility.}

\item{...}{additional arguments to \code{\link{plot_api_g}} or
\code{\link{plot_api_c}}}

\item{comp_idx}{Index of component to plot. The total sum is plotted
if this is \code{NULL}.}

\item{color_by}{name of coloring factor}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
\itemize{
  \item Function draws at data points can be visualized using
  \code{plot_pred}. If the \code{pred} argument is \code{NULL}, it
  is computed using the \code{\link{pred}} function with \code{x=NULL}.
  \item The total signal \code{f} or any of its
  additive components can be plotted using \code{plot_f}.
}
}
\seealso{
Other main plot functions: 
\code{\link{plot_components}()},
\code{\link{plot_draws}()}
}
\concept{main plot functions}
