% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_demographicFunctions.R
\name{Lxt}
\alias{Lxt}
\alias{Tx}
\title{Various demographic functions}
\usage{
Lxt(object, x, t = 1, fxt = 0.5)

Tx(object, x)
}
\arguments{
\item{object}{a \code{lifetable} or \code{actuarialtable} object}

\item{x}{age of the subject}

\item{t}{duration of the calculation}

\item{fxt}{correction constant, default 0.5}
}
\value{
A numeric value
}
\description{
Various demographic functions
}
\details{
\code{Tx} il the sum of years lived since age \code{x} by the population of the life table, it is the sum of \code{Lx}. The function is provided as is, 
without any warranty regarding the accuracy of calculations. Use at own risk.
}
\examples{
data(soaLt)
soa08Act=with(soaLt, new("actuarialtable",interest=0.06,
x=x,lx=Ix,name="SOA2008"))
Lxt(soa08Act, 67,10)
#assumes SOA example life table to be load
data(soaLt)
soa08Act=with(soaLt, new("actuarialtable",interest=0.06,x=x,lx=Ix,name="SOA2008"))
Tx(soa08Act, 67)
}
\references{
Actuarial Mathematics (Second Edition), 1997, by Bowers, N.L., Gerber, H.U., Hickman, J.C., Jones, D.A. and Nesbitt, C.J.
}
\author{
Giorgio Alfredo Spedicato.
}
