% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_explanations}
\alias{plot_explanations}
\title{Plot a condensed overview of all explanations}
\usage{
plot_explanations(explanation, ...)
}
\arguments{
\item{explanation}{A \code{data.frame} as returned by \code{\link[=explain]{explain()}}.}

\item{...}{Parameters passed on to \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}}
}
\value{
A \code{ggplot} object
}
\description{
This function produces a facetted heatmap visualisation of all
case/label/feature combinations. Compared to \code{\link[=plot_features]{plot_features()}} it is much
more condensed, thus allowing for an overview of many explanations in one
plot. On the other hand it is less useful for getting exact numerical
statistics of the explanation.
}
\examples{
# Create some explanations
library(MASS)
iris_test <- iris[c(1, 51, 101), 1:4]
iris_train <- iris[-c(1, 51, 101), 1:4]
iris_lab <- iris[[5]][-c(1, 51, 101)]
model <- lda(iris_train, iris_lab)
explanation <- lime(iris_train, model)
explanations <- explain(iris_test, explanation, n_labels = 1, n_features = 2)

# Get an overview with the standard plot
plot_explanations(explanations)
}
\seealso{
Other explanation plots: 
\code{\link{plot_features}()},
\code{\link{plot_text_explanations}()}
}
\concept{explanation plots}
