% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_net.R
\name{mark_features}
\alias{mark_features}
\alias{is_connected}
\alias{is_perfect_matching}
\alias{is_eulerian}
\alias{is_acyclic}
\alias{is_aperiodic}
\title{Marking networks features}
\source{
https://stackoverflow.com/questions/55091438/r-igraph-find-all-cycles
}
\usage{
is_connected(.data)

is_perfect_matching(.data, mark = "type")

is_eulerian(.data)

is_acyclic(.data)

is_aperiodic(.data, max_path_length = 4)
}
\arguments{
\item{.data}{An object of a \code{{manynet}}-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{mark}{A logical vector marking two types or modes.
By default "type".}

\item{max_path_length}{Maximum path length considered.
If negative, paths of all lengths are considered.
By default 4, to avoid potentially very long computation times.}
}
\value{
TRUE if the condition is met, or FALSE otherwise.
}
\description{
These functions implement logical tests for various network
features.
\itemize{
\item \code{is_connected()} tests whether network is strongly connected,
or weakly connected if undirected.
\item \code{is_perfect_matching()} tests whether there is a matching
for a network that covers every node in the network.
\item \code{is_eulerian()} tests whether there is a Eulerian path for a network
where that path passes through every tie exactly once.
\item \code{is_acyclic()} tests whether network is a directed acyclic graph.
\item \code{is_aperiodic()} tests whether network is aperiodic.
}
}
\section{is_connected}{

To test weak connection on a directed network,
please see \code{to_undirected()}.
}

\section{is_perfect_matching}{

For two-mode or bipartite networks, \code{to_matching()} is used
to identify whether a perfect matching is possible.
For one-mode networks, we use the Tutte theorem.
Note that currently only subgraphs with cutpoints removed are tested,
and not all possible subgraphs.
This is to avoid computationally expensive combinatorial operations,
but may come at the cost of some edge cases where a one-mode network
cannot perfectly match as suggested.
}

\examples{
is_connected(ison_southern_women)
is_perfect_matching(ison_southern_women)
is_eulerian(ison_brandes)
is_acyclic(ison_algebra)
is_aperiodic(ison_algebra)
}
\references{
\subsection{On perfect matching}{

Tutte, William T. 1950.
"The factorization of locally finite graphs".
\emph{Canadian Journal of Mathematics}. 2: 44–49.
\doi{10.4153/cjm-1950-005-2}
}

\subsection{On aperiodicity}{

Jarvis, J.P, and D.R. Shier. 1996.
"Graph-theoretic analysis of finite Markov chains",
in Shier, D.R., Wallenius, K.T. (eds) \emph{Applied Mathematical Modeling: A Multidisciplinary Approach}.
CRC Press.
}
}
\seealso{
Other marking: 
\code{\link{mark_format}},
\code{\link{mark_is}}
}
\concept{marking}
