# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

rangeTransform <- function(x, lbound = NA_real_, ubound = NA_real_) {
    .Call(`_mclustAddons_rangeTransform`, x, lbound, ubound)
}

powerTransform <- function(x, lambda = 1, eps = 1e-3) {
    .Call(`_mclustAddons_powerTransform`, x, lambda, eps)
}

rangepowerTransformDeriv_lb <- function(x, lambda = 1, lbound = NA_real_, eps = NA_real_) {
    .Call(`_mclustAddons_rangepowerTransformDeriv_lb`, x, lambda, lbound, eps)
}

rangepowerTransformDeriv_lub <- function(x, lambda = 1, lbound = NA_real_, ubound = NA_real_, eps = NA_real_, tol = 1e-3) {
    .Call(`_mclustAddons_rangepowerTransformDeriv_lub`, x, lambda, lbound, ubound, eps, tol)
}

rangepowerTransformDeriv_unb <- function(x, lambda = 1) {
    .Call(`_mclustAddons_rangepowerTransformDeriv_unb`, x, lambda)
}

rowMax <- function(X) {
    .Call(`_mclustAddons_rowMax`, X)
}

rowSum <- function(X) {
    .Call(`_mclustAddons_rowSum`, X)
}

colMax <- function(X) {
    .Call(`_mclustAddons_colMax`, X)
}

colSum <- function(X) {
    .Call(`_mclustAddons_colSum`, X)
}

#' @title Latin Hypercube Sampling
#'
#' @description
#' Generates a Latin Hypercube Sampling (LHS) design matrix over the hypercube.
#'
#' @param n Integer. The number of samples points of the hypercube.
#' @param d Integer. The the dimension of the hypercube.
#' @param lbound Numeric vector of length \code{d} specifying the 
#'   lower bounds for each dimension of the d-dimensional hypercube.
#' @param ubound Numeric vector of length \code{d} specifying the 
#'   ubound bounds for each dimension of the d-dimensional hypercube.
#'
#' @return A \code{n x d} matrix containing the LHS design. Each 
#'   element is scaled to the range defined by \code{lbound} and 
#'   \code{ubound}.
#'
#' @references McKay, M.D., Beckman, R.J., Conover, W.J. (1979) A comparison of 
#'   three methods for selecting values of input variables in the 
#'   analysis of output from a computer code. Technometrics. 21(2), 
#'   239–-245 (reprinted in 2000: Technometrics 42(1), 55–61).
#' @references Owen, A. B. (1992b) A central limit theorem for Latin hypercube
#'   sampling. JRSS Series B 54, 541-551.
#' @references Stein, M. (1987) Large sample properties of simulations using 
#'   Latin hypercube sampling. Technometrics 29, 143-151.
#'   
#' @examples
#' x = hypcube_lhs(100, 2)
#' plot(x, xlim = c(0,1), ylim = c(0,1))
#' rug(x[,1]); rug(x[,2], side = 2)
#' x = hypcube_lhs(100, 2, lbound = c(-5,1), ubound = c(10,3))
#' plot(x, xlim = c(-5,10), ylim = c(1,3))
#' rug(x[,1]); rug(x[,2], side = 2)
#' @export
hypcube_lhs <- function(n, d, lbound = NA_real_, ubound = NA_real_) {
    .Call(`_mclustAddons_hypcube_lhs`, n, d, lbound, ubound)
}

#' @title Simple Monte Carlo Sampling
#'
#' @description
#' This function generates a Simple Monte Carlo (SMC) random design 
#' matrix over the hypercube.
#'
#' @param n Integer. The number of samples points of the hypercube.
#' @param d Integer. The the dimension of the hypercube.
#' @param lbound Numeric vector of length \code{d} specifying the 
#'   lower bounds for each dimension of the d-dimensional hypercube.
#' @param ubound Numeric vector of length \code{d} specifying the 
#'   ubound bounds for each dimension of the d-dimensional hypercube.
#'
#' @return A \code{n x d} matrix containing the SMC design. Each 
#'   element is scaled to the range defined by \code{lbound} and 
#'   \code{ubound}.
#'
#' @examples
#' x = hypcube_smc(100, 2)
#' plot(x, xlim = c(0,1), ylim = c(0,1))
#' rug(x[,1]); rug(x[,2], side = 2)
#' x = hypcube_smc(100, 2, lbound = c(-5,1), ubound = c(10,3))
#' plot(x, xlim = c(-5,10), ylim = c(1,3))
#' rug(x[,1]); rug(x[,2], side = 2)
#'
#' @export
hypcube_smc <- function(n, d, lbound = NA_real_, ubound = NA_real_) {
    .Call(`_mclustAddons_hypcube_smc`, n, d, lbound, ubound)
}

inside_range <- function(x, r) {
    .Call(`_mclustAddons_inside_range`, x, r)
}

stable_exp_neg_diff <- function(x) {
    .Call(`_mclustAddons_stable_exp_neg_diff`, x)
}

logsumexp_Rcpp <- function(x, v) {
    .Call(`_mclustAddons_logsumexp_Rcpp`, x, v)
}

softmax_Rcpp <- function(x, v) {
    .Call(`_mclustAddons_softmax_Rcpp`, x, v)
}

