% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickands.R
\name{thselect.alrs}
\alias{thselect.alrs}
\title{Automatic L-moment ratio selection method}
\usage{
thselect.alrs(xdat, thresh, plot = FALSE)
}
\arguments{
\item{xdat}{[numeric] vector of observations}

\item{thresh}{[numeric] vector of candidate thresholds. If missing, 20 sample quantiles starting at the 0.25 quantile in increments of 3.75 percent.}

\item{plot}{[logical] if \code{TRUE}, return a plot of the sample L-kurtosis against the L-skewness, along with the theoretical generalized Pareto curve.}
}
\value{
scalar for the chosen numeric threshold
}
\description{
Given a sample of observations, calculate the L-skewness and L-kurtosis
over a set of candidate thresholds. For each threshold candidate, we
find the L-skewness that minimizes the sum of squared distance between the
theoretical L-skewness and L-kurtosis of the generalized Pareto distribution,
\deqn{\min_{\tau_3} (t_3-\tau_3)^2 + [t_4 - \tau_3(1+5\tau_3)/(5+\tau_3)]^2.}
The function returns the threshold with the minimum distance.
}
\references{
Silva Lomba, J., Fraga Alves, M.I. (2020). \emph{L-moments for automatic threshold selection in extreme value analysis}. Stoch Environ Res Risk Assess, 34, 465–491. \doi{10.1007/s00477-020-01789-x}
}
