% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{normalize}
\alias{normalize}
\title{Normalize the phyloseq object with different methods}
\usage{
normalize(physeq, group, method = "relative", table = FALSE)
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{group}{group (DESeq2). A character string specifying the name of a categorical variable containing  grouping information.}

\item{method}{A list of character strings specifying \code{method} to be used to normalize the phyloseq object
Available methods are: "relative","TMM","vst","log2".}

\item{table}{return a data.frame or not}
}
\value{
phyloseq object with normalized data
}
\description{
Normalize the phyloseq object with different methods
}
\examples{
{
data("Physeq")
phy<-normalize(physeq)
}
}
\author{
Kai Guo
}
