% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_mid.R
\name{print.mid}
\alias{print.mid}
\title{Print MID Models}
\usage{
\method{print}{mid}(x, digits = max(3L, getOption("digits") - 2L), main.effects = FALSE, ...)
}
\arguments{
\item{x}{a "mid" object to be printed.}

\item{digits}{an integer specifying the number of significant digits for printing.}

\item{main.effects}{logical. If \code{TRUE}, the MID values of each main effect are also printed.}

\item{...}{arguments to be passed to other methods (not used in this method).}
}
\value{
\code{print.mid()} returns the original "mid" object invisibly.
}
\description{
\code{print.mid()} is an S3 method for "mid" objects that prints a concise summary of a fitted MID model.
}
\details{
By default, the \code{print()} method for "mid" objects provides a quick overview of the model structure by listing the number of main effect and interaction terms.
If \code{main.effects = TRUE} is specified, the method will also print the contribution of each main effect at its sample points, providing a more detailed look at the model's components.
}
\examples{
data(cars, package = "datasets")
mid <- interpret(dist ~ speed, cars)

# Default print provides a concise summary
print(mid)

# Setting main.effects = TRUE prints the contributions of each main effect
print(mid, main.effects = TRUE)
}
\seealso{
\code{\link{interpret}}, \code{\link{summary.mid}}
}
