% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_all.R
\name{display_all}
\alias{display_all}
\title{Display All Possible Parameter Combinations for Cronbach's Alpha}
\usage{
display_all(
  scores_mat,
  score_max,
  tol = 0.001,
  num_random = 1000,
  num_opt = 1,
  methods = c("GA", "DEoptim", "nloptr"),
  enum_all = FALSE,
  rough = TRUE
)
}
\arguments{
\item{scores_mat}{A matrix where rows represent persons and columns represent tests (or items),
providing the performance of a person on a test. NA should be used for missing values.}

\item{score_max}{An integer indicating the largest possible score of the test.}

\item{tol}{A numeric value representing the desired accuracy in computing the lower and upper bound of Cronbach's alpha.}

\item{num_random}{An integer specifying the number of random samples used in estimating the lower and upper bound. Default is 1000.}

\item{num_opt}{An integer specifying the number of times to run the optimization algorithm. Default is 1.}

\item{methods}{A character vector specifying the optimization methods to be used (e.g., 'GA', 'DEoptim', 'nloptr'). Default is c('GA').}

\item{enum_all}{Logical, whether to include enumeration in the parameter combinations. Default is FALSE.}

\item{rough}{Logical, whether to include rough approximation in the parameter combinations. Default is TRUE.}
}
\value{
A list where each element is a result of the \code{cronbachs_alpha} function for a unique parameter combination, including computation time.
}
\description{
This function computes and displays all possible combinations of Cronbach's alpha
bounds for various parameter settings, including combinations of optimization
methods, rough approximation, random sampling, and enumeration.
}
