% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-search-cv.R
\name{FittedGridSearchCV}
\alias{FittedGridSearchCV}
\title{Fitted Models with Cross Validation across a Tuning Grid of Hyper-parameters}
\description{
\code{FittedGridSearchCV} is an object containing fitted predictive models across
a tuning grid of hyper-parameters returned by \code{GridSearchCV$fit()} as well as
relevant model information such as the best performing model, best
hyper-parameters, etc.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{best_idx}}{An integer specifying the index of \verb{$models} that
contains the best-performing model.}

\item{\code{best_metric}}{The average performance metric of the best model
across cross-validation folds.}

\item{\code{best_model}}{The best performing predictive model.}

\item{\code{best_params}}{A named list of the hyper-parameters that result in
the optimal predictive model.}

\item{\code{folds}}{A list of length \verb{$models} where each element contains a
list of the cross-validation indices for each fold.}

\item{\code{tune_params}}{A \link{data.frame} of the full hyper-parameter grid.}

\item{\code{models}}{List of predictive models at every value of \verb{$tune_params}.}

\item{\code{metrics}}{Numeric list; Cross-validation performance metrics for
every model in \verb{$models}.}

\item{\code{predictions}}{A list containing the cross-validation fold
predictions for each model in \verb{$models}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FittedGridSearchCV-new}{\code{FittedGridSearchCV$new()}}
\item \href{#method-FittedGridSearchCV-clone}{\code{FittedGridSearchCV$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FittedGridSearchCV-new"></a>}}
\if{latex}{\out{\hypertarget{method-FittedGridSearchCV-new}{}}}
\subsection{Method \code{new()}}{
Create a new \link{FittedGridSearchCV} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FittedGridSearchCV$new(
  tune_params,
  models,
  folds,
  metrics,
  predictions,
  optimize_score
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tune_params}}{Data.frame of the full hyper-parameter grid.}

\item{\code{models}}{List of predictive models at every value of \verb{$tune_params}.}

\item{\code{folds}}{List of cross-validation indices at every value of
\verb{$tune_params}.}

\item{\code{metrics}}{List of cross-validation performance metrics for
every model in \verb{$models}.}

\item{\code{predictions}}{A list containing the predicted values on the
cross-validation folds for every model in \verb{$models}.}

\item{\code{optimize_score}}{Either "max" or "min" indicating whether or not the
specified performance metric was maximized or minimized to find the
optimal predictive model.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{FittedGridSearchCV}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FittedGridSearchCV-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FittedGridSearchCV-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FittedGridSearchCV$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
