% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-db.R
\name{create_schema}
\alias{create_schema}
\title{Create a Schema in a Database if It Does Not Exist}
\usage{
create_schema(.con, database_name, schema_name)
}
\arguments{
\item{.con}{A valid \code{DBI} connection (DuckDB / MotherDuck).}

\item{database_name}{Name of the database to create/use.}

\item{schema_name}{Name of the schema to create if it does not exist.}
}
\value{
Invisibly returns \code{NULL}.
Side effect: creates the schema if necessary and prints CLI messages.
}
\description{
Ensures that a specified schema exists in the given database.
If the connection is to a MotherDuck instance, the function switches
to the specified database before creating the schema.
It also prints helpful connection and environment information via
CLI messages for transparency.
}
\details{
\itemize{
\item Uses \code{DBI::dbExecute()} with \verb{CREATE SCHEMA IF NOT EXISTS} to create
the schema only when needed.
\item If connected to MotherDuck (determined by
\code{validate_md_connection_status()}), executes \verb{USE <database>} before
creating the schema.
\item Displays connection/user/database information via internal CLI helpers.
}
}
\seealso{
Other db-manage: 
\code{\link{alter_table_schema}()},
\code{\link{copy_tables_to_new_location}()},
\code{\link{create_database}()},
\code{\link{create_if_not_exists_share}()},
\code{\link{create_or_replace_share}()},
\code{\link{create_table}()},
\code{\link{delete_and_create_schema}()},
\code{\link{delete_database}()},
\code{\link{delete_schema}()},
\code{\link{delete_table}()},
\code{\link{describe_share}()},
\code{\link{drop_share}()},
\code{\link{list_owned_shares}()},
\code{\link{list_shared_with_me_shares}()},
\code{\link{upload_database_to_md}()}
}
\concept{db-manage}
